/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package [=javaPackageBase].it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class [=toCapCamelCase(artifactIdBase)]Test {

[#if nativeSupported ]
    @Test
    public void test() {
        final String msg = java.util.UUID.randomUUID().toString().replace("-", "");
        RestAssured.given() //
                .contentType(ContentType.TEXT)
                .body(msg)
                .post("/[=artifactIdBase]/post") //
                .then()
                .statusCode(201);

        Assertions.fail("Add some assertions to " + getClass().getName());

        RestAssured.get("/[=artifactIdBase]/get")
                .then()
                .statusCode(200);
    }
[#else]
[#list models as model]
    @Test
    public void load[=toCapCamelCase(model.kind)][=toCapCamelCase(model.name)]() {
        /* A simple autogenerated test */
        RestAssured.get("/[=artifactIdBase]/load/[=model.kind]/[=toKebabCase(model.name)]")
                .then()
                .statusCode(200);
    }
[/#list]
[/#if]

}
