// This file was automatically generated through the build.rs script, and should not be edited.

// This file is @generated by prost-build.
///
/// The request that a client provides to a server on handshake.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct HandshakeRequest {
    ///
    /// A defined protocol version
    #[prost(uint64, tag = "1")]
    pub protocol_version: u64,
    ///
    /// Arbitrary auth/handshake info.
    #[prost(bytes = "bytes", tag = "2")]
    pub payload: ::prost::bytes::Bytes,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct HandshakeResponse {
    ///
    /// A defined protocol version
    #[prost(uint64, tag = "1")]
    pub protocol_version: u64,
    ///
    /// Arbitrary auth/handshake info.
    #[prost(bytes = "bytes", tag = "2")]
    pub payload: ::prost::bytes::Bytes,
}
///
/// A message for doing simple auth.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct BasicAuth {
    #[prost(string, tag = "2")]
    pub username: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub password: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Empty {}
///
/// Describes an available action, including both the name used for execution
/// along with a short description of the purpose of the action.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ActionType {
    #[prost(string, tag = "1")]
    pub r#type: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub description: ::prost::alloc::string::String,
}
///
/// A service specific expression that can be used to return a limited set
/// of available Arrow Flight streams.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Criteria {
    #[prost(bytes = "bytes", tag = "1")]
    pub expression: ::prost::bytes::Bytes,
}
///
/// An opaque action specific for the service.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Action {
    #[prost(string, tag = "1")]
    pub r#type: ::prost::alloc::string::String,
    #[prost(bytes = "bytes", tag = "2")]
    pub body: ::prost::bytes::Bytes,
}
///
/// The request of the CancelFlightInfo action.
///
/// The request should be stored in Action.body.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CancelFlightInfoRequest {
    #[prost(message, optional, tag = "1")]
    pub info: ::core::option::Option<FlightInfo>,
}
///
/// The request of the RenewFlightEndpoint action.
///
/// The request should be stored in Action.body.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RenewFlightEndpointRequest {
    #[prost(message, optional, tag = "1")]
    pub endpoint: ::core::option::Option<FlightEndpoint>,
}
///
/// An opaque result returned after executing an action.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Result {
    #[prost(bytes = "bytes", tag = "1")]
    pub body: ::prost::bytes::Bytes,
}
///
/// The result of the CancelFlightInfo action.
///
/// The result should be stored in Result.body.
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CancelFlightInfoResult {
    #[prost(enumeration = "CancelStatus", tag = "1")]
    pub status: i32,
}
///
/// Wrap the result of a getSchema call
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SchemaResult {
    /// The schema of the dataset in its IPC form:
    ///    4 bytes - an optional IPC_CONTINUATION_TOKEN prefix
    ///    4 bytes - the byte length of the payload
    ///    a flatbuffer Message whose header is the Schema
    #[prost(bytes = "bytes", tag = "1")]
    pub schema: ::prost::bytes::Bytes,
}
///
/// The name or tag for a Flight. May be used as a way to retrieve or generate
/// a flight or be used to expose a set of previously defined flights.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct FlightDescriptor {
    #[prost(enumeration = "flight_descriptor::DescriptorType", tag = "1")]
    pub r#type: i32,
    ///
    /// Opaque value used to express a command. Should only be defined when
    /// type = CMD.
    #[prost(bytes = "bytes", tag = "2")]
    pub cmd: ::prost::bytes::Bytes,
    ///
    /// List of strings identifying a particular dataset. Should only be defined
    /// when type = PATH.
    #[prost(string, repeated, tag = "3")]
    pub path: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `FlightDescriptor`.
pub mod flight_descriptor {
    ///
    /// Describes what type of descriptor is defined.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum DescriptorType {
        /// Protobuf pattern, not used.
        Unknown = 0,
        ///
        /// A named path that identifies a dataset. A path is composed of a string
        /// or list of strings describing a particular dataset. This is conceptually
        ///   similar to a path inside a filesystem.
        Path = 1,
        ///
        /// An opaque command to generate a dataset.
        Cmd = 2,
    }
    impl DescriptorType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unknown => "UNKNOWN",
                Self::Path => "PATH",
                Self::Cmd => "CMD",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNKNOWN" => Some(Self::Unknown),
                "PATH" => Some(Self::Path),
                "CMD" => Some(Self::Cmd),
                _ => None,
            }
        }
    }
}
///
/// The access coordinates for retrieval of a dataset. With a FlightInfo, a
/// consumer is able to determine how to retrieve a dataset.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FlightInfo {
    /// The schema of the dataset in its IPC form:
    ///    4 bytes - an optional IPC_CONTINUATION_TOKEN prefix
    ///    4 bytes - the byte length of the payload
    ///    a flatbuffer Message whose header is the Schema
    #[prost(bytes = "bytes", tag = "1")]
    pub schema: ::prost::bytes::Bytes,
    ///
    /// The descriptor associated with this info.
    #[prost(message, optional, tag = "2")]
    pub flight_descriptor: ::core::option::Option<FlightDescriptor>,
    ///
    /// A list of endpoints associated with the flight. To consume the
    /// whole flight, all endpoints (and hence all Tickets) must be
    /// consumed. Endpoints can be consumed in any order.
    ///
    /// In other words, an application can use multiple endpoints to
    /// represent partitioned data.
    ///
    /// If the returned data has an ordering, an application can use
    /// "FlightInfo.ordered = true" or should return the all data in a
    /// single endpoint. Otherwise, there is no ordering defined on
    /// endpoints or the data within.
    ///
    /// A client can read ordered data by reading data from returned
    /// endpoints, in order, from front to back.
    ///
    /// Note that a client may ignore "FlightInfo.ordered = true". If an
    /// ordering is important for an application, an application must
    /// choose one of them:
    ///
    /// * An application requires that all clients must read data in
    ///    returned endpoints order.
    /// * An application must return the all data in a single endpoint.
    #[prost(message, repeated, tag = "3")]
    pub endpoint: ::prost::alloc::vec::Vec<FlightEndpoint>,
    /// Set these to -1 if unknown.
    #[prost(int64, tag = "4")]
    pub total_records: i64,
    #[prost(int64, tag = "5")]
    pub total_bytes: i64,
    ///
    /// FlightEndpoints are in the same order as the data.
    #[prost(bool, tag = "6")]
    pub ordered: bool,
    ///
    /// Application-defined metadata.
    ///
    /// There is no inherent or required relationship between this
    /// and the app_metadata fields in the FlightEndpoints or resulting
    /// FlightData messages. Since this metadata is application-defined,
    /// a given application could define there to be a relationship,
    /// but there is none required by the spec.
    #[prost(bytes = "bytes", tag = "7")]
    pub app_metadata: ::prost::bytes::Bytes,
}
///
/// The information to process a long-running query.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PollInfo {
    ///
    /// The currently available results.
    ///
    /// If "flight_descriptor" is not specified, the query is complete
    /// and "info" specifies all results. Otherwise, "info" contains
    /// partial query results.
    ///
    /// Note that each PollInfo response contains a complete
    /// FlightInfo (not just the delta between the previous and current
    /// FlightInfo).
    ///
    /// Subsequent PollInfo responses may only append new endpoints to
    /// info.
    ///
    /// Clients can begin fetching results via DoGet(Ticket) with the
    /// ticket in the info before the query is
    /// completed. FlightInfo.ordered is also valid.
    #[prost(message, optional, tag = "1")]
    pub info: ::core::option::Option<FlightInfo>,
    ///
    /// The descriptor the client should use on the next try.
    /// If unset, the query is complete.
    #[prost(message, optional, tag = "2")]
    pub flight_descriptor: ::core::option::Option<FlightDescriptor>,
    ///
    /// Query progress. If known, must be in \[0.0, 1.0\] but need not be
    /// monotonic or nondecreasing. If unknown, do not set.
    #[prost(double, optional, tag = "3")]
    pub progress: ::core::option::Option<f64>,
    ///
    /// Expiration time for this request. After this passes, the server
    /// might not accept the retry descriptor anymore (and the query may
    /// be cancelled). This may be updated on a call to PollFlightInfo.
    #[prost(message, optional, tag = "4")]
    pub expiration_time: ::core::option::Option<::prost_types::Timestamp>,
}
///
/// A particular stream or split associated with a flight.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FlightEndpoint {
    ///
    /// Token used to retrieve this stream.
    #[prost(message, optional, tag = "1")]
    pub ticket: ::core::option::Option<Ticket>,
    ///
    /// A list of URIs where this ticket can be redeemed via DoGet().
    ///
    /// If the list is empty, the expectation is that the ticket can only
    /// be redeemed on the current service where the ticket was
    /// generated.
    ///
    /// If the list is not empty, the expectation is that the ticket can
    /// be redeemed at any of the locations, and that the data returned
    /// will be equivalent. In this case, the ticket may only be redeemed
    /// at one of the given locations, and not (necessarily) on the
    /// current service.
    ///
    /// In other words, an application can use multiple locations to
    /// represent redundant and/or load balanced services.
    #[prost(message, repeated, tag = "2")]
    pub location: ::prost::alloc::vec::Vec<Location>,
    ///
    /// Expiration time of this stream. If present, clients may assume
    /// they can retry DoGet requests. Otherwise, it is
    /// application-defined whether DoGet requests may be retried.
    #[prost(message, optional, tag = "3")]
    pub expiration_time: ::core::option::Option<::prost_types::Timestamp>,
    ///
    /// Application-defined metadata.
    ///
    /// There is no inherent or required relationship between this
    /// and the app_metadata fields in the FlightInfo or resulting
    /// FlightData messages. Since this metadata is application-defined,
    /// a given application could define there to be a relationship,
    /// but there is none required by the spec.
    #[prost(bytes = "bytes", tag = "4")]
    pub app_metadata: ::prost::bytes::Bytes,
}
///
/// A location where a Flight service will accept retrieval of a particular
/// stream given a ticket.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Location {
    #[prost(string, tag = "1")]
    pub uri: ::prost::alloc::string::String,
}
///
/// An opaque identifier that the service can use to retrieve a particular
/// portion of a stream.
///
/// Tickets are meant to be single use. It is an error/application-defined
/// behavior to reuse a ticket.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Ticket {
    #[prost(bytes = "bytes", tag = "1")]
    pub ticket: ::prost::bytes::Bytes,
}
///
/// A batch of Arrow data as part of a stream of batches.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct FlightData {
    ///
    /// The descriptor of the data. This is only relevant when a client is
    /// starting a new DoPut stream.
    #[prost(message, optional, tag = "1")]
    pub flight_descriptor: ::core::option::Option<FlightDescriptor>,
    ///
    /// Header for message data as described in Message.fbs::Message.
    #[prost(bytes = "bytes", tag = "2")]
    pub data_header: ::prost::bytes::Bytes,
    ///
    /// Application-defined metadata.
    #[prost(bytes = "bytes", tag = "3")]
    pub app_metadata: ::prost::bytes::Bytes,
    ///
    /// The actual batch of Arrow data. Preferably handled with minimal-copies
    /// coming last in the definition to help with sidecar patterns (it is
    /// expected that some implementations will fetch this field off the wire
    /// with specialized code to avoid extra memory copies).
    #[prost(bytes = "bytes", tag = "1000")]
    pub data_body: ::prost::bytes::Bytes,
}
/// *
/// The response message associated with the submission of a DoPut.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct PutResult {
    #[prost(bytes = "bytes", tag = "1")]
    pub app_metadata: ::prost::bytes::Bytes,
}
///
/// The result of a cancel operation.
///
/// This is used by CancelFlightInfoResult.status.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum CancelStatus {
    /// The cancellation status is unknown. Servers should avoid using
    /// this value (send a NOT_FOUND error if the requested query is
    /// not known). Clients can retry the request.
    Unspecified = 0,
    /// The cancellation request is complete. Subsequent requests with
    /// the same payload may return CANCELLED or a NOT_FOUND error.
    Cancelled = 1,
    /// The cancellation request is in progress. The client may retry
    /// the cancellation request.
    Cancelling = 2,
    /// The query is not cancellable. The client should not retry the
    /// cancellation request.
    NotCancellable = 3,
}
impl CancelStatus {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "CANCEL_STATUS_UNSPECIFIED",
            Self::Cancelled => "CANCEL_STATUS_CANCELLED",
            Self::Cancelling => "CANCEL_STATUS_CANCELLING",
            Self::NotCancellable => "CANCEL_STATUS_NOT_CANCELLABLE",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "CANCEL_STATUS_UNSPECIFIED" => Some(Self::Unspecified),
            "CANCEL_STATUS_CANCELLED" => Some(Self::Cancelled),
            "CANCEL_STATUS_CANCELLING" => Some(Self::Cancelling),
            "CANCEL_STATUS_NOT_CANCELLABLE" => Some(Self::NotCancellable),
            _ => None,
        }
    }
}
/// Generated client implementations.
pub mod flight_service_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    ///
    /// A flight service is an endpoint for retrieving or storing Arrow data. A
    /// flight service can expose one or more predefined endpoints that can be
    /// accessed using the Arrow Flight Protocol. Additionally, a flight service
    /// can expose a set of actions that are available.
    #[derive(Debug, Clone)]
    pub struct FlightServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl<T> FlightServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> FlightServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::Body>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::Body>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            FlightServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        ///
        /// Handshake between client and server. Depending on the server, the
        /// handshake may be required to determine the token that should be used for
        /// future operations. Both request and response are streams to allow multiple
        /// round-trips depending on auth mechanism.
        pub async fn handshake(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::HandshakeRequest>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::HandshakeResponse>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/Handshake",
            );
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("arrow.flight.protocol.FlightService", "Handshake"),
                );
            self.inner.streaming(req, path, codec).await
        }
        ///
        /// Get a list of available streams given a particular criteria. Most flight
        /// services will expose one or more streams that are readily available for
        /// retrieval. This api allows listing the streams available for
        /// consumption. A user can also provide a criteria. The criteria can limit
        /// the subset of streams that can be listed via this interface. Each flight
        /// service allows its own definition of how to consume criteria.
        pub async fn list_flights(
            &mut self,
            request: impl tonic::IntoRequest<super::Criteria>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::FlightInfo>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/ListFlights",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("arrow.flight.protocol.FlightService", "ListFlights"),
                );
            self.inner.server_streaming(req, path, codec).await
        }
        ///
        /// For a given FlightDescriptor, get information about how the flight can be
        /// consumed. This is a useful interface if the consumer of the interface
        /// already can identify the specific flight to consume. This interface can
        /// also allow a consumer to generate a flight stream through a specified
        /// descriptor. For example, a flight descriptor might be something that
        /// includes a SQL statement or a Pickled Python operation that will be
        /// executed. In those cases, the descriptor will not be previously available
        /// within the list of available streams provided by ListFlights but will be
        /// available for consumption for the duration defined by the specific flight
        /// service.
        pub async fn get_flight_info(
            &mut self,
            request: impl tonic::IntoRequest<super::FlightDescriptor>,
        ) -> std::result::Result<tonic::Response<super::FlightInfo>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/GetFlightInfo",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "arrow.flight.protocol.FlightService",
                        "GetFlightInfo",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        ///
        /// For a given FlightDescriptor, start a query and get information
        /// to poll its execution status. This is a useful interface if the
        /// query may be a long-running query. The first PollFlightInfo call
        /// should return as quickly as possible. (GetFlightInfo doesn't
        /// return until the query is complete.)
        ///
        /// A client can consume any available results before
        /// the query is completed. See PollInfo.info for details.
        ///
        /// A client can poll the updated query status by calling
        /// PollFlightInfo() with PollInfo.flight_descriptor. A server
        /// should not respond until the result would be different from last
        /// time. That way, the client can "long poll" for updates
        /// without constantly making requests. Clients can set a short timeout
        /// to avoid blocking calls if desired.
        ///
        /// A client can't use PollInfo.flight_descriptor after
        /// PollInfo.expiration_time passes. A server might not accept the
        /// retry descriptor anymore and the query may be cancelled.
        ///
        /// A client may use the CancelFlightInfo action with
        /// PollInfo.info to cancel the running query.
        pub async fn poll_flight_info(
            &mut self,
            request: impl tonic::IntoRequest<super::FlightDescriptor>,
        ) -> std::result::Result<tonic::Response<super::PollInfo>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/PollFlightInfo",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "arrow.flight.protocol.FlightService",
                        "PollFlightInfo",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        ///
        /// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
        /// This is used when a consumer needs the Schema of flight stream. Similar to
        /// GetFlightInfo this interface may generate a new flight that was not previously
        /// available in ListFlights.
        pub async fn get_schema(
            &mut self,
            request: impl tonic::IntoRequest<super::FlightDescriptor>,
        ) -> std::result::Result<tonic::Response<super::SchemaResult>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/GetSchema",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("arrow.flight.protocol.FlightService", "GetSchema"),
                );
            self.inner.unary(req, path, codec).await
        }
        ///
        /// Retrieve a single stream associated with a particular descriptor
        /// associated with the referenced ticket. A Flight can be composed of one or
        /// more streams where each stream can be retrieved using a separate opaque
        /// ticket that the flight service uses for managing a collection of streams.
        pub async fn do_get(
            &mut self,
            request: impl tonic::IntoRequest<super::Ticket>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::FlightData>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/DoGet",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("arrow.flight.protocol.FlightService", "DoGet"));
            self.inner.server_streaming(req, path, codec).await
        }
        ///
        /// Push a stream to the flight service associated with a particular
        /// flight stream. This allows a client of a flight service to upload a stream
        /// of data. Depending on the particular flight service, a client consumer
        /// could be allowed to upload a single stream per descriptor or an unlimited
        /// number. In the latter, the service might implement a 'seal' action that
        /// can be applied to a descriptor once all streams are uploaded.
        pub async fn do_put(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::FlightData>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::PutResult>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/DoPut",
            );
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("arrow.flight.protocol.FlightService", "DoPut"));
            self.inner.streaming(req, path, codec).await
        }
        ///
        /// Open a bidirectional data channel for a given descriptor. This
        /// allows clients to send and receive arbitrary Arrow data and
        /// application-specific metadata in a single logical stream. In
        /// contrast to DoGet/DoPut, this is more suited for clients
        /// offloading computation (rather than storage) to a Flight service.
        pub async fn do_exchange(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::FlightData>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::FlightData>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/DoExchange",
            );
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("arrow.flight.protocol.FlightService", "DoExchange"),
                );
            self.inner.streaming(req, path, codec).await
        }
        ///
        /// Flight services can support an arbitrary number of simple actions in
        /// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
        /// operations that are potentially available. DoAction allows a flight client
        /// to do a specific action against a flight service. An action includes
        /// opaque request and response objects that are specific to the type action
        /// being undertaken.
        pub async fn do_action(
            &mut self,
            request: impl tonic::IntoRequest<super::Action>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::Result>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/DoAction",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("arrow.flight.protocol.FlightService", "DoAction"),
                );
            self.inner.server_streaming(req, path, codec).await
        }
        ///
        /// A flight service exposes all of the available action types that it has
        /// along with descriptions. This allows different flight consumers to
        /// understand the capabilities of the flight service.
        pub async fn list_actions(
            &mut self,
            request: impl tonic::IntoRequest<super::Empty>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::ActionType>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/arrow.flight.protocol.FlightService/ListActions",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("arrow.flight.protocol.FlightService", "ListActions"),
                );
            self.inner.server_streaming(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod flight_service_server {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with FlightServiceServer.
    #[async_trait]
    pub trait FlightService: std::marker::Send + std::marker::Sync + 'static {
        /// Server streaming response type for the Handshake method.
        type HandshakeStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::HandshakeResponse, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        ///
        /// Handshake between client and server. Depending on the server, the
        /// handshake may be required to determine the token that should be used for
        /// future operations. Both request and response are streams to allow multiple
        /// round-trips depending on auth mechanism.
        async fn handshake(
            &self,
            request: tonic::Request<tonic::Streaming<super::HandshakeRequest>>,
        ) -> std::result::Result<tonic::Response<Self::HandshakeStream>, tonic::Status>;
        /// Server streaming response type for the ListFlights method.
        type ListFlightsStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::FlightInfo, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        ///
        /// Get a list of available streams given a particular criteria. Most flight
        /// services will expose one or more streams that are readily available for
        /// retrieval. This api allows listing the streams available for
        /// consumption. A user can also provide a criteria. The criteria can limit
        /// the subset of streams that can be listed via this interface. Each flight
        /// service allows its own definition of how to consume criteria.
        async fn list_flights(
            &self,
            request: tonic::Request<super::Criteria>,
        ) -> std::result::Result<
            tonic::Response<Self::ListFlightsStream>,
            tonic::Status,
        >;
        ///
        /// For a given FlightDescriptor, get information about how the flight can be
        /// consumed. This is a useful interface if the consumer of the interface
        /// already can identify the specific flight to consume. This interface can
        /// also allow a consumer to generate a flight stream through a specified
        /// descriptor. For example, a flight descriptor might be something that
        /// includes a SQL statement or a Pickled Python operation that will be
        /// executed. In those cases, the descriptor will not be previously available
        /// within the list of available streams provided by ListFlights but will be
        /// available for consumption for the duration defined by the specific flight
        /// service.
        async fn get_flight_info(
            &self,
            request: tonic::Request<super::FlightDescriptor>,
        ) -> std::result::Result<tonic::Response<super::FlightInfo>, tonic::Status>;
        ///
        /// For a given FlightDescriptor, start a query and get information
        /// to poll its execution status. This is a useful interface if the
        /// query may be a long-running query. The first PollFlightInfo call
        /// should return as quickly as possible. (GetFlightInfo doesn't
        /// return until the query is complete.)
        ///
        /// A client can consume any available results before
        /// the query is completed. See PollInfo.info for details.
        ///
        /// A client can poll the updated query status by calling
        /// PollFlightInfo() with PollInfo.flight_descriptor. A server
        /// should not respond until the result would be different from last
        /// time. That way, the client can "long poll" for updates
        /// without constantly making requests. Clients can set a short timeout
        /// to avoid blocking calls if desired.
        ///
        /// A client can't use PollInfo.flight_descriptor after
        /// PollInfo.expiration_time passes. A server might not accept the
        /// retry descriptor anymore and the query may be cancelled.
        ///
        /// A client may use the CancelFlightInfo action with
        /// PollInfo.info to cancel the running query.
        async fn poll_flight_info(
            &self,
            request: tonic::Request<super::FlightDescriptor>,
        ) -> std::result::Result<tonic::Response<super::PollInfo>, tonic::Status>;
        ///
        /// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
        /// This is used when a consumer needs the Schema of flight stream. Similar to
        /// GetFlightInfo this interface may generate a new flight that was not previously
        /// available in ListFlights.
        async fn get_schema(
            &self,
            request: tonic::Request<super::FlightDescriptor>,
        ) -> std::result::Result<tonic::Response<super::SchemaResult>, tonic::Status>;
        /// Server streaming response type for the DoGet method.
        type DoGetStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::FlightData, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        ///
        /// Retrieve a single stream associated with a particular descriptor
        /// associated with the referenced ticket. A Flight can be composed of one or
        /// more streams where each stream can be retrieved using a separate opaque
        /// ticket that the flight service uses for managing a collection of streams.
        async fn do_get(
            &self,
            request: tonic::Request<super::Ticket>,
        ) -> std::result::Result<tonic::Response<Self::DoGetStream>, tonic::Status>;
        /// Server streaming response type for the DoPut method.
        type DoPutStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::PutResult, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        ///
        /// Push a stream to the flight service associated with a particular
        /// flight stream. This allows a client of a flight service to upload a stream
        /// of data. Depending on the particular flight service, a client consumer
        /// could be allowed to upload a single stream per descriptor or an unlimited
        /// number. In the latter, the service might implement a 'seal' action that
        /// can be applied to a descriptor once all streams are uploaded.
        async fn do_put(
            &self,
            request: tonic::Request<tonic::Streaming<super::FlightData>>,
        ) -> std::result::Result<tonic::Response<Self::DoPutStream>, tonic::Status>;
        /// Server streaming response type for the DoExchange method.
        type DoExchangeStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::FlightData, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        ///
        /// Open a bidirectional data channel for a given descriptor. This
        /// allows clients to send and receive arbitrary Arrow data and
        /// application-specific metadata in a single logical stream. In
        /// contrast to DoGet/DoPut, this is more suited for clients
        /// offloading computation (rather than storage) to a Flight service.
        async fn do_exchange(
            &self,
            request: tonic::Request<tonic::Streaming<super::FlightData>>,
        ) -> std::result::Result<tonic::Response<Self::DoExchangeStream>, tonic::Status>;
        /// Server streaming response type for the DoAction method.
        type DoActionStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::Result, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        ///
        /// Flight services can support an arbitrary number of simple actions in
        /// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
        /// operations that are potentially available. DoAction allows a flight client
        /// to do a specific action against a flight service. An action includes
        /// opaque request and response objects that are specific to the type action
        /// being undertaken.
        async fn do_action(
            &self,
            request: tonic::Request<super::Action>,
        ) -> std::result::Result<tonic::Response<Self::DoActionStream>, tonic::Status>;
        /// Server streaming response type for the ListActions method.
        type ListActionsStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::ActionType, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        ///
        /// A flight service exposes all of the available action types that it has
        /// along with descriptions. This allows different flight consumers to
        /// understand the capabilities of the flight service.
        async fn list_actions(
            &self,
            request: tonic::Request<super::Empty>,
        ) -> std::result::Result<
            tonic::Response<Self::ListActionsStream>,
            tonic::Status,
        >;
    }
    ///
    /// A flight service is an endpoint for retrieving or storing Arrow data. A
    /// flight service can expose one or more predefined endpoints that can be
    /// accessed using the Arrow Flight Protocol. Additionally, a flight service
    /// can expose a set of actions that are available.
    #[derive(Debug)]
    pub struct FlightServiceServer<T> {
        inner: Arc<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    impl<T> FlightServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for FlightServiceServer<T>
    where
        T: FlightService,
        B: Body + std::marker::Send + 'static,
        B::Error: Into<StdError> + std::marker::Send + 'static,
    {
        type Response = http::Response<tonic::body::Body>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            match req.uri().path() {
                "/arrow.flight.protocol.FlightService/Handshake" => {
                    #[allow(non_camel_case_types)]
                    struct HandshakeSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::StreamingService<super::HandshakeRequest>
                    for HandshakeSvc<T> {
                        type Response = super::HandshakeResponse;
                        type ResponseStream = T::HandshakeStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<
                                tonic::Streaming<super::HandshakeRequest>,
                            >,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::handshake(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = HandshakeSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/ListFlights" => {
                    #[allow(non_camel_case_types)]
                    struct ListFlightsSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::ServerStreamingService<super::Criteria>
                    for ListFlightsSvc<T> {
                        type Response = super::FlightInfo;
                        type ResponseStream = T::ListFlightsStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::Criteria>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::list_flights(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ListFlightsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/GetFlightInfo" => {
                    #[allow(non_camel_case_types)]
                    struct GetFlightInfoSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::UnaryService<super::FlightDescriptor>
                    for GetFlightInfoSvc<T> {
                        type Response = super::FlightInfo;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::FlightDescriptor>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::get_flight_info(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetFlightInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/PollFlightInfo" => {
                    #[allow(non_camel_case_types)]
                    struct PollFlightInfoSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::UnaryService<super::FlightDescriptor>
                    for PollFlightInfoSvc<T> {
                        type Response = super::PollInfo;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::FlightDescriptor>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::poll_flight_info(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = PollFlightInfoSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/GetSchema" => {
                    #[allow(non_camel_case_types)]
                    struct GetSchemaSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::UnaryService<super::FlightDescriptor>
                    for GetSchemaSvc<T> {
                        type Response = super::SchemaResult;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::FlightDescriptor>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::get_schema(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetSchemaSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/DoGet" => {
                    #[allow(non_camel_case_types)]
                    struct DoGetSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::ServerStreamingService<super::Ticket>
                    for DoGetSvc<T> {
                        type Response = super::FlightData;
                        type ResponseStream = T::DoGetStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::Ticket>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::do_get(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DoGetSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/DoPut" => {
                    #[allow(non_camel_case_types)]
                    struct DoPutSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::StreamingService<super::FlightData>
                    for DoPutSvc<T> {
                        type Response = super::PutResult;
                        type ResponseStream = T::DoPutStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<tonic::Streaming<super::FlightData>>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::do_put(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DoPutSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/DoExchange" => {
                    #[allow(non_camel_case_types)]
                    struct DoExchangeSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::StreamingService<super::FlightData>
                    for DoExchangeSvc<T> {
                        type Response = super::FlightData;
                        type ResponseStream = T::DoExchangeStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<tonic::Streaming<super::FlightData>>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::do_exchange(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DoExchangeSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/DoAction" => {
                    #[allow(non_camel_case_types)]
                    struct DoActionSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::ServerStreamingService<super::Action>
                    for DoActionSvc<T> {
                        type Response = super::Result;
                        type ResponseStream = T::DoActionStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::Action>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::do_action(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = DoActionSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/arrow.flight.protocol.FlightService/ListActions" => {
                    #[allow(non_camel_case_types)]
                    struct ListActionsSvc<T: FlightService>(pub Arc<T>);
                    impl<
                        T: FlightService,
                    > tonic::server::ServerStreamingService<super::Empty>
                    for ListActionsSvc<T> {
                        type Response = super::ActionType;
                        type ResponseStream = T::ListActionsStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::Empty>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as FlightService>::list_actions(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ListActionsSvc(inner);
                        let codec = tonic_prost::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        let mut response = http::Response::new(
                            tonic::body::Body::default(),
                        );
                        let headers = response.headers_mut();
                        headers
                            .insert(
                                tonic::Status::GRPC_STATUS,
                                (tonic::Code::Unimplemented as i32).into(),
                            );
                        headers
                            .insert(
                                http::header::CONTENT_TYPE,
                                tonic::metadata::GRPC_CONTENT_TYPE,
                            );
                        Ok(response)
                    })
                }
            }
        }
    }
    impl<T> Clone for FlightServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    /// Generated gRPC service name
    pub const SERVICE_NAME: &str = "arrow.flight.protocol.FlightService";
    impl<T> tonic::server::NamedService for FlightServiceServer<T> {
        const NAME: &'static str = SERVICE_NAME;
    }
}
