% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feather.R
\name{read_feather}
\alias{read_feather}
\alias{read_ipc_file}
\title{Read a Feather file (an Arrow IPC file)}
\usage{
read_feather(file, col_select = NULL, as_data_frame = TRUE, mmap = TRUE)

read_ipc_file(file, col_select = NULL, as_data_frame = TRUE, mmap = TRUE)
}
\arguments{
\item{file}{A character file name or URI, connection, \code{raw} vector, an
Arrow input stream, or a \code{FileSystem} with path (\code{SubTreeFileSystem}).
If a file name or URI, an Arrow \link{InputStream} will be opened and
closed when finished. If an input stream is provided, it will be left
open.}

\item{col_select}{A character vector of column names to keep, as in the
"select" argument to \code{data.table::fread()}, or a
\link[tidyselect:eval_select]{tidy selection specification}
of columns, as used in \code{dplyr::select()}.}

\item{as_data_frame}{Should the function return a \code{tibble} (default) or
an Arrow \link{Table}?}

\item{mmap}{Logical: whether to memory-map the file (default \code{TRUE})}
}
\value{
A \code{tibble} if \code{as_data_frame} is \code{TRUE} (the default), or an
Arrow \link{Table} otherwise
}
\description{
Feather provides binary columnar serialization for data frames.
It is designed to make reading and writing data frames efficient,
and to make sharing data across data analysis languages easy.
\code{\link[=read_feather]{read_feather()}} can read both the Feather Version 1 (V1), a legacy version available starting in 2016,
and the Version 2 (V2), which is the Apache Arrow IPC file format.
\code{\link[=read_ipc_file]{read_ipc_file()}} is an alias of \code{\link[=read_feather]{read_feather()}}.
}
\examples{
# We recommend the ".arrow" extension for Arrow IPC files (Feather V2).
tf <- tempfile(fileext = ".arrow")
on.exit(unlink(tf))
write_feather(mtcars, tf)
df <- read_feather(tf)
dim(df)
# Can select columns
df <- read_feather(tf, col_select = starts_with("d"))
}
\seealso{
\link{FeatherReader} and \link{RecordBatchReader} for lower-level access to reading Arrow IPC data.
}
