% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\docType{class}
\name{InputStream}
\alias{InputStream}
\alias{RandomAccessFile}
\alias{MemoryMappedFile}
\alias{ReadableFile}
\alias{BufferReader}
\title{InputStream classes}
\description{
\code{RandomAccessFile} inherits from \code{InputStream} and is a base
class for: \code{ReadableFile} for reading from a file; \code{MemoryMappedFile} for
the same but with memory mapping; and \code{BufferReader} for reading from a
buffer. Use these with the various table readers.
}
\section{Factory}{


The \verb{$create()} factory methods instantiate the \code{InputStream} object and
take the following arguments, depending on the subclass:
\itemize{
\item \code{path} For \code{ReadableFile}, a character file name
\item \code{x} For \code{BufferReader}, a \link{Buffer} or an object that can be
made into a buffer via \code{buffer()}.
}

To instantiate a \code{MemoryMappedFile}, call \code{\link[=mmap_open]{mmap_open()}}.
}

\section{Methods}{

\itemize{
\item \verb{$GetSize()}:
\item \verb{$supports_zero_copy()}: Logical
\item \verb{$seek(position)}: go to that position in the stream
\item \verb{$tell()}: return the position in the stream
\item \verb{$close()}: close the stream
\item \verb{$Read(nbytes)}: read data from the stream, either a specified \code{nbytes} or
all, if \code{nbytes} is not provided
\item \verb{$ReadAt(position, nbytes)}: similar to \verb{$seek(position)$Read(nbytes)}
\item \verb{$Resize(size)}: for a \code{MemoryMappedFile} that is writeable
}
}

