/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionProtocol;
import org.apache.activemq.artemis.cli.commands.messages.perf.BenchmarkService;
import org.apache.activemq.artemis.cli.commands.messages.perf.LiveStatistics;
import org.apache.activemq.artemis.cli.commands.messages.perf.MessageListenerBenchmark;
import org.apache.activemq.artemis.cli.commands.messages.perf.MessageListenerBenchmarkBuilder;
import org.apache.activemq.artemis.cli.commands.messages.perf.PerfCommand;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerBenchmark;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerBenchmarkBuilder;
import org.apache.activemq.artemis.cli.factory.ConnectionFactoryClosable;
import picocli.CommandLine;

@CommandLine.Command(name="client", description={"Produce messages to and consume messages from a broker instance."})
public class PerfClientCommand
extends PerfCommand {
    @CommandLine.Option(names={"--tx"}, description={"Perform Message::acknowledge per each message received. Default: disabled."})
    protected boolean transaction;
    @CommandLine.Option(names={"--shared"}, description={"Create a shared subscription. Default: 0."})
    protected int sharedSubscription = 0;
    @CommandLine.Option(names={"--durable"}, description={"Enabled durable subscription. Default: disabled."})
    protected boolean durableSubscription = false;
    @CommandLine.Option(names={"--consumer-connections"}, description={"Number of consumer connections to be used. Default: same as the total number of consumers"})
    protected int consumerConnections = 0;
    @CommandLine.Option(names={"--consumers"}, description={"Number of consumer to use for each generated destination. Default: 1."})
    protected int consumersPerDestination = 1;
    @CommandLine.Option(names={"--persistent"}, description={"Send messages persistently. Default: non persistent"})
    protected boolean persistent = false;
    @CommandLine.Option(names={"--message-size"}, description={"Size of each bytesMessage. Default: is 1024."})
    protected int messageSize = 1024;
    @CommandLine.Option(names={"--rate"}, description={"Expected total message rate. Default: unbounded."})
    protected Long rate = null;
    @CommandLine.Option(names={"--ttl"}, description={"TTL for each message."})
    protected long ttl = 0L;
    @CommandLine.Option(names={"--group"}, description={"Message Group to be used."})
    protected String msgGroupID = null;
    @CommandLine.Option(names={"--shared-connections"}, description={"Create --threads shared connections among producers. Default: not shared."})
    protected boolean sharedConnections = false;
    @CommandLine.Option(names={"--producers"}, description={"Number of producers to use for each generated destination. Default: 1"})
    protected int producersPerDestination = 1;
    @CommandLine.Option(names={"--threads"}, description={"Number of worker threads to schedule producer load tasks. Default: 1."})
    protected int threads = 1;
    @CommandLine.Option(names={"--max-pending"}, description={"How many not yet completed messages can exists. Default: 1."})
    protected long maxPending = 1L;
    @CommandLine.Option(names={"--consumer-url"}, description={"The url used for MessageListener(s) connections. Default: same as --url."})
    protected String consumerUrl = null;
    @CommandLine.Option(names={"--consumer-protocol"}, description={"The protocol used for MessageListener(s) connections. Default: same as --protocol. Valid values are ${COMPLETION-CANDIDATES}"}, converter={ConnectionProtocol.ProtocolConverter.class})
    protected ConnectionProtocol consumerProtocol = null;
    @CommandLine.Option(names={"--enable-msg-id"}, description={"Set JMS messageID per-message. Default: disabled."})
    protected boolean enableMessageID;
    @CommandLine.Option(names={"--enable-timestamp"}, description={"Set JMS timestamp per-message. Default: disabled."})
    protected boolean enableTimestamp;
    private volatile BenchmarkService producerBenchmark;

    @Override
    protected void onExecuteBenchmark(ConnectionFactory producerConnectionFactory, Destination[] jmsDestinations, ActionContext context) throws Exception {
        int totalProducers;
        ConnectionProtocol listenerProtocol = Objects.requireNonNullElse(this.consumerProtocol, this.protocol);
        String listenerUrl = Objects.requireNonNullElse(this.consumerUrl, this.brokerURL);
        ConnectionFactoryClosable consumerConnectionFactory = this.createConnectionFactory(listenerUrl, this.user, this.password, null, listenerProtocol);
        if (this.consumerConnections == 0) {
            this.consumerConnections = this.sharedSubscription > 0 ? (this.getClientID() == null ? this.sharedSubscription * this.consumersPerDestination * jmsDestinations.length : this.sharedSubscription * jmsDestinations.length) : this.consumersPerDestination * jmsDestinations.length;
        }
        if (this.threads >= (totalProducers = this.producersPerDestination * jmsDestinations.length) && this.threads > totalProducers) {
            context.err.println("Doesn't make sense to set workers > producers: auto-adjusting it to be the same as the producer count");
            this.threads = totalProducers;
        }
        boolean warmingUp = this.warmup != 0;
        StringBuilder skratchBuffer = new StringBuilder();
        try (MessageListenerBenchmark consumerBenchmark = new MessageListenerBenchmarkBuilder().setClientID(this.getClientID()).setDestinations(this.consumerProtocol != null ? this.lookupDestinations(consumerConnectionFactory) : jmsDestinations).setFactory(consumerConnectionFactory).setTransacted(this.transaction).setConsumers(this.consumersPerDestination).setConnections(this.consumerConnections).setTimeProvider(() -> TimeUnit.NANOSECONDS.toMicros(System.nanoTime())).setCanDelayMessageCount(true).setSharedSubscription(this.sharedSubscription).setDurableSubscription(this.durableSubscription).createMessageListenerBenchmark();){
            LiveStatistics statistics;
            DefaultEventLoopGroup eventLoopGroup = new DefaultEventLoopGroup(this.threads){

                protected EventLoop newChild(Executor executor, Object ... args) {
                    return new DefaultEventLoop((EventLoopGroup)this, executor){

                        protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
                            return new LinkedTransferQueue<Runnable>();
                        }
                    };
                }
            };
            try (ProducerBenchmark producerBenchmark = new ProducerBenchmarkBuilder().setPersistent(this.persistent).setDestinations(jmsDestinations).setFactory(producerConnectionFactory).setTtl(this.ttl).setTransactionCapacity(this.commitInterval).setGroup(this.msgGroupID).setProducers(this.producersPerDestination).setMessageRate(this.rate).setMessageCount(this.messageCount).setMessageSize(this.messageSize).setTimeProvider(() -> TimeUnit.NANOSECONDS.toMicros(System.nanoTime())).setLoopGroup((EventLoopGroup)eventLoopGroup).setMaxPending(this.maxPending).setSharedConnections(this.sharedConnections).setEnableMessageID(this.enableMessageID).setEnableTimestamp(this.enableTimestamp).createProducerBenchmark();){
                this.producerBenchmark = producerBenchmark;
                consumerBenchmark.start();
                producerBenchmark.start();
                long now = System.currentTimeMillis();
                long endWarmup = this.warmup > 0 ? now + TimeUnit.SECONDS.toMillis(this.warmup) : 0L;
                long end = this.duration > 0 ? now + TimeUnit.SECONDS.toMillis(this.duration) : 0L;
                statistics = new LiveStatistics(this.reportFileName, this.hdrFileName, producerBenchmark.getGenerators(), consumerBenchmark.getListeners());
                LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
                warmingUp = this.collectAndReportStatisticsWhileRunning(warmingUp, statistics, skratchBuffer, endWarmup, end, producerBenchmark);
                boolean producerFatalError = producerBenchmark.anyError();
                producerBenchmark.asyncClose();
                if (!producerFatalError) {
                    consumerBenchmark.setMessageCount(producerBenchmark.expectedTotalMessageCountToReceive(this.sharedSubscription, this.consumersPerDestination));
                    warmingUp = this.collectAndReportStatisticsWhileRunning(warmingUp, statistics, skratchBuffer, endWarmup, 0L, consumerBenchmark);
                }
            }
            statistics.sampleMetrics(warmingUp);
            skratchBuffer.setLength(0);
            statistics.outSummary(skratchBuffer);
            if (!this.isSilentInput()) {
                context.out.println(skratchBuffer);
            }
            eventLoopGroup.shutdownGracefully();
            statistics.close();
        }
    }

    @Override
    protected void onInterruptBenchmark() {
        BenchmarkService benchmark = this.producerBenchmark;
        if (benchmark != null) {
            benchmark.close();
        }
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        if (this.durableSubscription && (this.destinations == null || this.destinations.isEmpty())) {
            this.destinations = Collections.singletonList("topic://TEST");
        }
        if (this.durableSubscription && this.clientID == null) {
            throw new IllegalArgumentException("The clientID must be set on durable subscriptions");
        }
        return super.execute(context);
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public PerfClientCommand setTransaction(boolean transaction) {
        this.transaction = transaction;
        return this;
    }

    public int getSharedSubscription() {
        return this.sharedSubscription;
    }

    public PerfClientCommand setSharedSubscription(int sharedSubscription) {
        this.sharedSubscription = sharedSubscription;
        return this;
    }

    public boolean isDurableSubscription() {
        return this.durableSubscription;
    }

    public PerfClientCommand setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
        return this;
    }

    public int getConsumerConnections() {
        return this.consumerConnections;
    }

    public PerfClientCommand setConsumerConnections(int consumerConnections) {
        this.consumerConnections = consumerConnections;
        return this;
    }

    public int getConsumersPerDestination() {
        return this.consumersPerDestination;
    }

    public PerfClientCommand setConsumersPerDestination(int consumersPerDestination) {
        this.consumersPerDestination = consumersPerDestination;
        return this;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public PerfClientCommand setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public PerfClientCommand setMessageSize(int messageSize) {
        this.messageSize = messageSize;
        return this;
    }

    public Long getRate() {
        return this.rate;
    }

    public PerfClientCommand setRate(Long rate) {
        this.rate = rate;
        return this;
    }

    public long getTtl() {
        return this.ttl;
    }

    public PerfClientCommand setTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public String getMsgGroupID() {
        return this.msgGroupID;
    }

    public PerfClientCommand setMsgGroupID(String msgGroupID) {
        this.msgGroupID = msgGroupID;
        return this;
    }

    public boolean isSharedConnections() {
        return this.sharedConnections;
    }

    public PerfClientCommand setSharedConnections(boolean sharedConnections) {
        this.sharedConnections = sharedConnections;
        return this;
    }

    public int getProducersPerDestination() {
        return this.producersPerDestination;
    }

    public PerfClientCommand setProducersPerDestination(int producersPerDestination) {
        this.producersPerDestination = producersPerDestination;
        return this;
    }

    public int getThreads() {
        return this.threads;
    }

    public PerfClientCommand setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public long getMaxPending() {
        return this.maxPending;
    }

    public PerfClientCommand setMaxPending(long maxPending) {
        this.maxPending = maxPending;
        return this;
    }

    public String getConsumerUrl() {
        return this.consumerUrl;
    }

    public PerfClientCommand setConsumerUrl(String consumerUrl) {
        this.consumerUrl = consumerUrl;
        return this;
    }

    public String getConsumerProtocol() {
        return this.consumerProtocol.toString();
    }

    public PerfClientCommand setConsumerProtocol(String consumerProtocol) {
        this.consumerProtocol = ConnectionProtocol.fromString(consumerProtocol);
        return this;
    }

    public boolean isEnableMessageID() {
        return this.enableMessageID;
    }

    public PerfClientCommand setEnableMessageID(boolean enableMessageID) {
        this.enableMessageID = enableMessageID;
        return this;
    }

    public boolean isEnableTimestamp() {
        return this.enableTimestamp;
    }

    public PerfClientCommand setEnableTimestamp(boolean enableTimestamp) {
        this.enableTimestamp = enableTimestamp;
        return this;
    }

    public BenchmarkService getProducerBenchmark() {
        return this.producerBenchmark;
    }

    public PerfClientCommand setProducerBenchmark(BenchmarkService producerBenchmark) {
        this.producerBenchmark = producerBenchmark;
        return this;
    }
}

