/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.create;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.admin.InitialTableState;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.TableInfo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.create.SetupPermissions;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CreateTable.class);
    private final TableInfo tableInfo = new TableInfo();

    public CreateTable(String user, String tableName, TimeType timeType, Map<String, String> props, Path splitPath, int splitCount, Path splitDirsPath, InitialTableState initialTableState, NamespaceId namespaceId) {
        this.tableInfo.setTableName(tableName);
        this.tableInfo.setTimeType(timeType);
        this.tableInfo.setUser(user);
        this.tableInfo.props = props;
        this.tableInfo.setNamespaceId(namespaceId);
        this.tableInfo.setSplitPath(splitPath);
        this.tableInfo.setInitialSplitSize(splitCount);
        this.tableInfo.setInitialTableState(initialTableState);
        this.tableInfo.setSplitDirsPath(splitDirsPath);
    }

    @Override
    public long isReady(long tid, Manager environment) throws Exception {
        return Utils.reserveNamespace(environment, this.tableInfo.getNamespaceId(), tid, false, true, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Utils.getIdLock().lock();
        try {
            String tName = this.tableInfo.getTableName();
            this.tableInfo.setTableId(Utils.getNextId(tName, manager.getContext(), TableId::of));
            SetupPermissions setupPermissions = new SetupPermissions(this.tableInfo);
            return setupPermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo(long tid, Manager env) throws IOException {
        Path p = null;
        try {
            if (this.tableInfo.getInitialSplitSize() > 0) {
                p = this.tableInfo.getSplitPath().getParent();
                FileSystem fs = p.getFileSystem(env.getContext().getHadoopConf());
                fs.delete(p, true);
            }
        }
        catch (IOException e) {
            log.error("Table failed to be created and failed to clean up split files at {}", p, (Object)e);
        }
        finally {
            Utils.unreserveNamespace(env, this.tableInfo.getNamespaceId(), tid, false);
        }
    }
}

