/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.tserver.tablet.CommitSession;

public class PreparedMutations {
    private final Violations violations;
    private final Collection<Mutation> violators;
    private final List<Mutation> nonViolators;
    private final CommitSession commitSession;
    private final boolean tabletClosed;

    public PreparedMutations() {
        this.tabletClosed = true;
        this.violations = null;
        this.violators = null;
        this.nonViolators = null;
        this.commitSession = null;
    }

    public PreparedMutations(CommitSession cs, List<Mutation> nonViolators, Violations violations, Set<Mutation> violators) {
        this.tabletClosed = false;
        this.nonViolators = Objects.requireNonNull(nonViolators);
        this.violators = Objects.requireNonNull(violators);
        this.violations = Objects.requireNonNull(violations);
        if (cs == null) {
            Preconditions.checkArgument((boolean)nonViolators.isEmpty());
        }
        this.commitSession = cs;
    }

    public boolean tabletClosed() {
        return this.tabletClosed;
    }

    public CommitSession getCommitSession() {
        Preconditions.checkState((!this.tabletClosed ? 1 : 0) != 0);
        return this.commitSession;
    }

    public Violations getViolations() {
        Preconditions.checkState((!this.tabletClosed ? 1 : 0) != 0);
        return this.violations;
    }

    public Collection<Mutation> getViolators() {
        Preconditions.checkState((!this.tabletClosed ? 1 : 0) != 0);
        return this.violators;
    }

    public List<Mutation> getNonViolators() {
        Preconditions.checkState((!this.tabletClosed ? 1 : 0) != 0);
        return this.nonViolators;
    }
}

