/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.server.compaction.CompactionWatcher;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.metrics.TabletServerMetricsUtil;

public class TabletServerMetrics
implements MetricsProducer {
    private final TabletServerMetricsUtil util;

    public TabletServerMetrics(TabletServer tserver) {
        this.util = new TabletServerMetricsUtil(tserver);
    }

    private long getTotalEntriesRead() {
        return FileCompactor.getTotalEntriesRead();
    }

    private long getTotalEntriesWritten() {
        return FileCompactor.getTotalEntriesWritten();
    }

    public void registerMetrics(MeterRegistry registry) {
        FunctionCounter.builder((String)"accumulo.compactor.entries.read", (Object)this, TabletServerMetrics::getTotalEntriesRead).description("Number of entries read by all compactions that have run on this tserver").register(registry);
        FunctionCounter.builder((String)"accumulo.compactor.entries.written", (Object)this, TabletServerMetrics::getTotalEntriesWritten).description("Number of entries written by all compactions that have run on this tserver").register(registry);
        LongTaskTimer timer = LongTaskTimer.builder((String)"accumulo.tserver.majc.stuck").description("Number and duration of stuck major compactions").register(registry);
        CompactionWatcher.setTimer((LongTaskTimer)timer);
        Gauge.builder((String)"accumulo.tserver.tablets.assignments.warning", (Object)this.util, TabletServerMetricsUtil::getLongTabletAssignments).description("Number of tablet assignments that are taking a long time").register(registry);
        Gauge.builder((String)"accumulo.tserver.entries", (Object)this.util, TabletServerMetricsUtil::getEntries).description("Number of entries").register(registry);
        Gauge.builder((String)"accumulo.tserver.entries.mem", (Object)this.util, TabletServerMetricsUtil::getEntriesInMemory).description("Number of entries in memory").register(registry);
        Gauge.builder((String)"accumulo.tserver.majc.running", (Object)this.util, TabletServerMetricsUtil::getMajorCompactions).description("Number of active major compactions").register(registry);
        Gauge.builder((String)"accumulo.tserver.majc.queued", (Object)this.util, TabletServerMetricsUtil::getMajorCompactionsQueued).description("Number of queued major compactions").register(registry);
        Gauge.builder((String)"accumulo.tserver.minc.running", (Object)this.util, TabletServerMetricsUtil::getMinorCompactions).description("Number of active minor compactions").register(registry);
        Gauge.builder((String)"accumulo.tserver.minc.queued", (Object)this.util, TabletServerMetricsUtil::getMinorCompactionsQueued).description("Number of queued minor compactions").register(registry);
        Gauge.builder((String)"accumulo.tserver.tablets.online", (Object)this.util, TabletServerMetricsUtil::getOnlineCount).description("Number of online tablets").register(registry);
        Gauge.builder((String)"accumulo.tserver.tablets.opening", (Object)this.util, TabletServerMetricsUtil::getOpeningCount).description("Number of opening tablets").register(registry);
        Gauge.builder((String)"accumulo.tserver.tablets.unopened", (Object)this.util, TabletServerMetricsUtil::getUnopenedCount).description("Number of unopened tablets").register(registry);
        Gauge.builder((String)"accumulo.tserver.minc.total", (Object)this.util, TabletServerMetricsUtil::getTotalMinorCompactions).description("Total number of minor compactions performed").register(registry);
        Gauge.builder((String)"accumulo.tserver.tablets.files", (Object)this.util, TabletServerMetricsUtil::getAverageFilesPerTablet).description("Number of files per tablet").register(registry);
        Gauge.builder((String)"accumulo.tserver.hold", (Object)this.util, TabletServerMetricsUtil::getHoldTime).description("Time commits held").register(registry);
        Gauge.builder((String)"accumulo.tserver.ingest.mutations", (Object)this.util, TabletServerMetricsUtil::getIngestCount).description("Ingest rate (entries/sec)").register(registry);
        Gauge.builder((String)"accumulo.tserver.ingest.bytes", (Object)this.util, TabletServerMetricsUtil::getIngestByteCount).description("Ingest rate (bytes/sec)").register(registry);
    }
}

