/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.memory;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.conf.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMapLoader {
    private static final Logger log = LoggerFactory.getLogger(NativeMapLoader.class);
    private static final Pattern dotSuffix = Pattern.compile("[.][^.]*$");
    private static final String PROP_NAME = "accumulo.native.lib.path";
    private static final AtomicBoolean loaded = new AtomicBoolean(false);

    private NativeMapLoader() {
    }

    public static synchronized void load() {
        if (loaded.compareAndSet(false, true)) {
            if (NativeMapLoader.loadFromSearchPath(System.getProperty(PROP_NAME)) || NativeMapLoader.loadFromSystemLinker()) {
                return;
            }
            log.error("FATAL! Accumulo native libraries were requested but could not be be loaded. Either set '{}' to false in accumulo.properties or make sure native libraries are created in directories set by the JVM system property '{}' in accumulo-env.sh!", (Object)Property.TSERV_NATIVEMAP_ENABLED, (Object)PROP_NAME);
            System.exit(1);
        }
    }

    public static void loadForTest(List<File> locations, Runnable onFail) {
        String searchPath = locations.stream().map(File::getAbsolutePath).collect(Collectors.joining(":"));
        if (!NativeMapLoader.loadFromSearchPath(searchPath)) {
            onFail.run();
        }
    }

    private static boolean loadFromSearchPath(String searchPath) {
        if (searchPath != null) {
            if (Stream.of(searchPath.split(":")).flatMap(NativeMapLoader::mapLibraryNames).anyMatch(NativeMapLoader::loadNativeLib)) {
                return true;
            }
            log.error("Tried and failed to load Accumulo native library from property {} set to {}", (Object)PROP_NAME, (Object)searchPath);
        }
        return false;
    }

    private static boolean loadFromSystemLinker() {
        String propName = "java.library.path";
        String ldLibPath = System.getProperty(propName);
        try {
            System.loadLibrary("accumulo");
            log.info("Loaded native map shared library from property {} set to {}", (Object)propName, (Object)ldLibPath);
            return true;
        }
        catch (Exception | UnsatisfiedLinkError e) {
            log.error("Tried and failed to load Accumulo native library from property {} set to {}", new Object[]{propName, ldLibPath, e});
            return false;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="search paths provided by admin")
    private static Stream<File> mapLibraryNames(String name) {
        File base = new File(name);
        if (!base.isDirectory()) {
            return Stream.of(base);
        }
        String libname = System.mapLibraryName("accumulo");
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            String prefix = dotSuffix.matcher(libname).replaceFirst("");
            Stream<String> stream = Stream.of(libname, prefix + ".dylib", prefix + ".jnilib").distinct();
        }
        Stream<String> libs = Stream.of(libname);
        return libs.map(f -> NativeMapLoader.appendFileToDir(base, f));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="search paths provided by admin")
    private static File appendFileToDir(File base, String f) {
        return new File(base, f);
    }

    private static boolean loadNativeLib(File libFile) {
        log.debug("Trying to load native map library {}", (Object)libFile);
        if (libFile.isFile()) {
            try {
                System.load(libFile.getAbsolutePath());
                log.info("Loaded native map shared library {}", (Object)libFile);
                return true;
            }
            catch (Exception | UnsatisfiedLinkError e) {
                log.error("Tried and failed to load native map library {}", (Object)libFile, (Object)e);
            }
        } else {
            log.debug("Native map library {} not found or is not a file", (Object)libFile);
        }
        return false;
    }
}

