/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbstractAbsoluteLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.SelectionActionsSupport;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class AbsoluteLayoutSelectionActionsTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_selectionActions() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"New Button1\");\n\t\t\tbutton.setBounds(70, 27, 83, 22);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New Button\");\n\t\t\tbutton.setBounds(41, 129, 134, 84);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(286, 135, 134, 120);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJLabel label = new JLabel(\"New Label\");\n\t\t\t\tlabel.setBounds(41, 53, 51, 13);\n\t\t\t\tsubPanel.add(label);\n\t\t\t}\n\t\t}\n\t}\n}");
        this.setupSelectionActions(panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ContainerInfo subPanel = (ContainerInfo)panel.getChildrenComponents().get(2);
        ComponentInfo label = (ComponentInfo)subPanel.getChildrenComponents().get(0);
        panel.refresh();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(button);
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertEquals((int)17, (int)actions.size());
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window"));
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(subPanel);
        actions.clear();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(label);
        actions.clear();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(label);
        selectedObjects.add((Object)new TestObjectInfo());
        actions.clear();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)actions.isEmpty());
    }

    @Test
    public void test_rootComponentInSelection() throws Exception {
        String lines = "class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 10, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}";
        ContainerInfo panel = this.parseContainer(lines);
        this.setupSelectionActions(panel);
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(button);
        selectedObjects.add(panel);
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_align_left_edges_1a() throws Exception {
        this.check_align_horizontal("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(20, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(20, 50, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align left edges", true);
    }

    @Test
    public void test_align_left_edges_1b() throws Exception {
        this.check_align_horizontal("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(10, 50, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align left edges", false);
    }

    @Test
    public void test_align_left_edges_2a() throws Exception {
        this.check_align_horizontal2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(30, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(5, 40, 300, 100);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(25, 55, 150, 30);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align left edges", true);
    }

    @Test
    public void test_align_left_edges_2b() throws Exception {
        this.check_align_horizontal2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(5, 40, 300, 100);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, 55, 150, 30);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align left edges", false);
    }

    @Test
    public void test_align_right_edges_1a() throws Exception {
        this.check_align_horizontal("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(70, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(20, 50, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align right edges", true);
    }

    @Test
    public void test_align_right_edges_1b() throws Exception {
        this.check_align_horizontal("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(-40, 50, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align right edges", false);
    }

    @Test
    public void test_align_right_edges_2a() throws Exception {
        this.check_align_horizontal2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(80, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(5, 40, 300, 100);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(25, 55, 150, 30);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align right edges", true);
    }

    @Test
    public void test_align_right_edges_2b() throws Exception {
        this.check_align_horizontal2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(5, 40, 300, 100);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(-45, 55, 150, 30);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align right edges", false);
    }

    @Test
    public void test_align_horizontal_centers_1a() throws Exception {
        this.check_align_horizontal("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(45, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(20, 50, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align horizontal centers", true);
    }

    @Test
    public void test_align_horizontal_centers_1b() throws Exception {
        this.check_align_horizontal("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(-15, 50, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align horizontal centers", false);
    }

    @Test
    public void test_align_horizontal_centers_2a() throws Exception {
        this.check_align_horizontal2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(55, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(5, 40, 300, 100);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(25, 55, 150, 30);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align horizontal centers", true);
    }

    @Test
    public void test_align_horizontal_centers_2b() throws Exception {
        this.check_align_horizontal2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(5, 40, 300, 100);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(-20, 55, 150, 30);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align horizontal centers", false);
    }

    private void check_align_horizontal(String expectedSource, String action, boolean toUp) throws Exception {
        this.check_align("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(20, 50, 150, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", expectedSource, action, toUp);
    }

    private void check_align_horizontal2(String expectedSource, String action, boolean toUp) throws Exception {
        this.check_align2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 20);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(5, 40, 300, 100);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(25, 55, 150, 30);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", expectedSource, action, toUp);
    }

    @Test
    public void test_align_top_edges_1a() throws Exception {
        this.check_align_vertical("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 100, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align top edges", true);
    }

    @Test
    public void test_align_top_edges_1b() throws Exception {
        this.check_align_vertical("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 10, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align top edges", false);
    }

    @Test
    public void test_align_top_edges_2a() throws Exception {
        this.check_align_vertical2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 100, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(65, 5, 300, 300);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, 95, 100, 80);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align top edges", true);
    }

    @Test
    public void test_align_top_edges_2b() throws Exception {
        this.check_align_vertical2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(65, 5, 300, 300);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, 5, 100, 80);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align top edges", false);
    }

    @Test
    public void test_align_bottom_edges_1a() throws Exception {
        this.check_align_vertical("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 140, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align bottom edges", true);
    }

    @Test
    public void test_align_bottom_edges_1b() throws Exception {
        this.check_align_vertical("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, -30, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align bottom edges", false);
    }

    @Test
    public void test_align_bottom_edges_2a() throws Exception {
        this.check_align_vertical2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 140, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(65, 5, 300, 300);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, 95, 100, 80);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align bottom edges", true);
    }

    @Test
    public void test_align_bottom_edges_2b() throws Exception {
        this.check_align_vertical2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(65, 5, 300, 300);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, -35, 100, 80);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align bottom edges", false);
    }

    @Test
    public void test_align_vertical_centers_1a() throws Exception {
        this.check_align_vertical("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 120, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align vertical centers", true);
    }

    @Test
    public void test_align_vertical_centers_1b() throws Exception {
        this.check_align_vertical("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, -10, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Align vertical centers", false);
    }

    @Test
    public void test_align_vertical_centers_2a() throws Exception {
        this.check_align_vertical2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 120, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(65, 5, 300, 300);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, 95, 100, 80);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align vertical centers", true);
    }

    @Test
    public void test_align_vertical_centers_2b() throws Exception {
        this.check_align_vertical2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(65, 5, 300, 300);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, -15, 100, 80);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", "Align vertical centers", false);
    }

    private void check_align_vertical(String newSource, String action, boolean toUp) throws Exception {
        this.check_align("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", newSource, action, toUp);
    }

    private void check_align_vertical2(String newSource, String action, boolean toUp) throws Exception {
        this.check_align2("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel subPanel = new JPanel();\n\t\t\tsubPanel.setLayout(null);\n\t\t\tsubPanel.setBounds(65, 5, 300, 300);\n\t\t\tadd(subPanel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"111\");\n\t\t\t\tbutton.setBounds(5, 95, 100, 80);\n\t\t\t\tsubPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}", newSource, action, toUp);
    }

    @Test
    public void test_align_replicate_width() throws Exception {
        this.check_align("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 100, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Replicate width", true);
    }

    @Test
    public void test_align_replicate_height() throws Exception {
        this.check_align("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 40);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 80);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(70, 100, 100, 80);\n\t\t\tadd(button);\n\t\t}\n\t}\n}", "Replicate height", true);
    }

    @Test
    public void test_align_space_equally_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(600, 400);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(30, 90, 100, 70);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(40, 200, 50, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").run();
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").run();
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(600, 400);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(150, 100, 100, 70);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(400, 270, 50, 30);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_align_space_equally_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(400, 400);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 50);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(90, 90, 60, 60);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"222\");\n\t\t\tbutton.setBounds(220, 220, 70, 70);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(2));
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        try {
            ReflectionUtils.setField(DesignerPlugin.class, (String)"m_ctrlPressed", (Object)true);
            AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").run();
            AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").run();
        }
        finally {
            ReflectionUtils.setField(DesignerPlugin.class, (String)"m_ctrlPressed", (Object)false);
        }
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(400, 400);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 50, 50);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tbutton.setBounds(110, 110, 60, 60);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"222\");\n\t\t\tbutton.setBounds(220, 220, 70, 70);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_align_center_in_window() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(600, 400);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(10, 10, 60, 40);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").run();
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").run();
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(600, 400);\n\t\t{\n\t\t\tJButton button = new JButton(\"000\");\n\t\t\tbutton.setBounds(270, 180, 60, 40);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_JTabbedPane_onWayToRoot() throws Exception {
        ContainerInfo root = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tJTabbedPane tabbed = new JTabbedPane();\n\t\tadd(tabbed);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\ttabbed.addTab(\"Tab\", panel);\n\t\t\tpanel.setLayout(null);\n\t\t\t{\n\t\t\t\tJButton button_1 = new JButton();\n\t\t\t\tpanel.add(button_1);\n\t\t\t\tbutton_1.setBounds(10, 10, 100, 50);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button_2 = new JButton();\n\t\t\t\tpanel.add(button_2);\n\t\t\t\tbutton_2.setBounds(20, 100, 100, 50);\n\t\t\t}\n\t\t}\n\t}\n}");
        root.refresh();
        ArrayList selectedObjects = new ArrayList();
        selectedObjects.add(AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("button_1"));
        selectedObjects.add(AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("button_2"));
        ContainerInfo panel = (ContainerInfo)AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("panel");
        this.setupSelectionActions(panel);
        ArrayList actions = new ArrayList();
        root.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").run();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tJTabbedPane tabbed = new JTabbedPane();\n\t\tadd(tabbed);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\ttabbed.addTab(\"Tab\", panel);\n\t\t\tpanel.setLayout(null);\n\t\t\t{\n\t\t\t\tJButton button_1 = new JButton();\n\t\t\t\tpanel.add(button_1);\n\t\t\t\tbutton_1.setBounds(10, 10, 100, 50);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button_2 = new JButton();\n\t\t\t\tpanel.add(button_2);\n\t\t\t\tbutton_2.setBounds(10, 100, 100, 50);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    private void check_align(String initialSource, String expectedSource, String action, boolean toUp) throws Exception {
        ContainerInfo panel = this.parseContainer(initialSource);
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        if (toUp) {
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        } else {
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
        }
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, action).run();
        this.assertEditor(expectedSource);
    }

    private void check_align2(String initialSource, String expectedSource, String action, boolean toUp) throws Exception {
        ContainerInfo panel = this.parseContainer(initialSource);
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        ContainerInfo subPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        this.setupSelectionActions(subPanel);
        if (toUp) {
            selectedObjects.add((ObjectInfo)subPanel.getChildrenComponents().get(0));
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        } else {
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
            selectedObjects.add((ObjectInfo)subPanel.getChildrenComponents().get(0));
        }
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, action).run();
        this.assertEditor(expectedSource);
    }

    private void setupSelectionActions(final ContainerInfo panel) {
        panel.addBroadcastListener((Object)new ObjectEventListener(){

            public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
                new SelectionActionsSupport((AbstractAbsoluteLayoutInfo)((AbsoluteLayoutInfo)panel.getLayout())).addAlignmentActions(objects, actions);
            }
        });
    }
}

