/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.gef.EditPart;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.rcp.model.widgets.ViewFormInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Test;

public class ViewFormGefTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_CREATE_topLeft() throws Exception {
        ViewFormInfo composite = this.prepare_canvas_CREATE();
        this.canvas.target(composite).in(0.1, 0.1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopLeft(button);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_topCenter() throws Exception {
        ViewFormInfo composite = this.prepare_canvas_CREATE();
        this.canvas.target(composite).in(0.6, 0.1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopCenter(button);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_topRight() throws Exception {
        ViewFormInfo composite = this.prepare_canvas_CREATE();
        this.canvas.target(composite).in(-0.1, 0.1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopRight(button);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_content() throws Exception {
        ViewFormInfo composite = this.prepare_canvas_CREATE();
        this.canvas.target(composite).in(0.3, 0.3).move();
        this.canvas.click();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setContent(button);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_notControl() throws Exception {
        ViewFormInfo composite = this.prepare_canvas_CREATE0();
        this.loadCreationTool("org.eclipse.swt.widgets.Menu");
        this.canvas.create(0, 0);
        this.canvas.target(composite).in(0.3, 0.3).move();
        this.canvas.click();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "    }", "  }", "}");
    }

    private ViewFormInfo prepare_canvas_CREATE() throws Exception {
        ViewFormInfo composite = this.prepare_canvas_CREATE0();
        this.loadCreationButton();
        this.canvas.create(0, 0);
        return composite;
    }

    private ViewFormInfo prepare_canvas_CREATE0() throws Exception {
        this.prepareComponent();
        return (ViewFormInfo)this.openJavaInfo("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
    }

    @Test
    public void test_canvas_PASTE() throws Exception {
        ViewFormInfo composite = (ViewFormInfo)this.openJavaInfo("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setEnabled(false);", "      setTopLeft(buttonA);", "    }", "  }", "}");
        ControlInfo buttonA = (ControlInfo)composite.getChildrenControls().get(0);
        this.doCopyPaste((JavaInfo)buttonA);
        this.canvas.create();
        this.canvas.target(composite).in(-0.1, 0.1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setEnabled(false);", "      setTopLeft(buttonA);", "    }", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setEnabled(false);", "      setTopRight(buttonA);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_MOVE() throws Exception {
        ViewFormInfo composite = (ViewFormInfo)this.openJavaInfo("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopLeft(button);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        this.canvas.beginMove(button);
        this.canvas.target(composite).in(-0.1, 0.1).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopRight(button);", "    }", "  }", "}");
        this.canvas.beginMove(button);
        this.canvas.target(composite).in(0.3, 0.3).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setContent(button);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_ADD() throws Exception {
        ViewFormInfo composite = (ViewFormInfo)this.openJavaInfo("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopLeft(button);", "    }", "    {", "      Button centerButton = new Button(this, SWT.NONE);", "      setTopCenter(centerButton);", "    }", "    {", "      ViewForm inner = new ViewForm(this, SWT.NONE);", "      setContent(inner);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        ViewFormInfo inner = (ViewFormInfo)composite.getChildrenControls().get(2);
        this.canvas.beginMove(button);
        this.canvas.target(inner).in(-0.1, 0.1).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button centerButton = new Button(this, SWT.NONE);", "      setTopCenter(centerButton);", "    }", "    {", "      ViewForm inner = new ViewForm(this, SWT.NONE);", "      setContent(inner);", "      {", "        Button button = new Button(inner, SWT.NONE);", "        inner.setTopRight(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE_empty() throws Exception {
        ViewFormInfo composite = (ViewFormInfo)this.openJavaInfo("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        EditPart topLeftPart = (EditPart)this.tree.getEditPart(composite).getChildren().get(0);
        this.loadButton();
        this.tree.moveOn(topLeftPart);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopLeft(button);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        ViewFormInfo composite = (ViewFormInfo)this.openJavaInfo("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopLeft(button);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)ViewFormGefTest.getJavaInfoByName("button");
        EditPart topLeftPart = (EditPart)this.tree.getEditPart(composite).getChildren().get(2);
        this.tree.startDrag(button).dragOn(topLeftPart).endDrag();
        this.assertEditor("public class Test extends ViewForm {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      setTopRight(button);", "    }", "  }", "}");
    }
}

