/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.property;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.property.editor.AcceleratorPropertyEditor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AcceleratorPropertyEditorTest
extends RcpModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        AcceleratorPropertyEditorTest.setFileContentSrc("test/MyControl.java", this.getTestSource("public class MyControl extends Composite {", "  public MyControl(Composite parent, int style) {", "    super(parent, style);", "  }", "  public void setAccelerator(int accelerator) {", "  }", "}"));
        AcceleratorPropertyEditorTest.setFileContentSrc("test/MyControl.wbp-component.xml", AcceleratorPropertyEditorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setAccelerator(int)'>", "    <editor id='swtAccelerator'/>", "  </property>", "</component>"));
        AcceleratorPropertyEditorTest.waitForAutoBuild();
    }

    @Test
    public void test_getText_0() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends MyControl {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        Property property = composite.getPropertyByTitle("accelerator");
        AcceleratorPropertyEditorTest.assertEquals(null, (Object)AcceleratorPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_getText_1() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends MyControl {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setAccelerator(SWT.CTRL | SWT.F2);", "  }", "}");
        Property property = composite.getPropertyByTitle("accelerator");
        AcceleratorPropertyEditorTest.assertEquals((Object)"CTRL+F2", (Object)AcceleratorPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_getText_2() throws Exception {
        this.dontConvertSingleQuotesToDouble();
        CompositeInfo composite = this.parseComposite("public class Test extends MyControl {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setAccelerator(SWT.CTRL | SWT.SHIFT | 'T');", "  }", "}");
        Property property = composite.getPropertyByTitle("accelerator");
        AcceleratorPropertyEditorTest.assertEquals((Object)"CTRL+SHIFT+T", (Object)AcceleratorPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_getText_3() throws Exception {
        this.dontConvertSingleQuotesToDouble();
        CompositeInfo composite = this.parseComposite("public class Test extends MyControl {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setAccelerator(SWT.SHIFT | SWT.CTRL | 'T');", "  }", "}");
        Property property = composite.getPropertyByTitle("accelerator");
        AcceleratorPropertyEditorTest.assertEquals((Object)"CTRL+SHIFT+T", (Object)AcceleratorPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_getText_4() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends MyControl {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setAccelerator(SWT.CTRL | SWT.ALT | SWT.SHIFT | SWT.DEL);", "  }", "}");
        Property property = composite.getPropertyByTitle("accelerator");
        AcceleratorPropertyEditorTest.assertEquals((Object)"ALT+CTRL+SHIFT+DEL", (Object)AcceleratorPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_getSource() throws Exception {
        int accelerator = 0x100000A;
        AcceleratorPropertyEditorTest.assertEquals((Object)"org.eclipse.swt.SWT.F1", (Object)AcceleratorPropertyEditorTest.getAcceleratorSource(accelerator));
        accelerator = 262228;
        AcceleratorPropertyEditorTest.assertEquals((Object)"org.eclipse.swt.SWT.CTRL | 'T'", (Object)AcceleratorPropertyEditorTest.getAcceleratorSource(accelerator));
        accelerator = 17039371;
        AcceleratorPropertyEditorTest.assertEquals((Object)"org.eclipse.swt.SWT.CTRL | org.eclipse.swt.SWT.F2", (Object)AcceleratorPropertyEditorTest.getAcceleratorSource(accelerator));
    }

    private static String getAcceleratorSource(int accelerator) throws Exception {
        return (String)ReflectionUtils.invokeMethod2(AcceleratorPropertyEditor.class, (String)"getSource", Integer.TYPE, (Object)accelerator);
    }
}

