/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.search;

import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.tests.search.AbstractSearchTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestFieldSearch
extends AbstractSearchTest {
    @Test
    public void testFieldDeclarationSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName(), new String[]{"X.js"}, new String[]{"var searchField = {\n\t" + this.getName() + ": 5,\n" + "\t" + this.getName() + "XYZ: 10,\n" + "};\n"}, 4, 0, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testFieldDeclarationSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "SearchConstructor." + this.getName(), new String[]{"X.js"}, new String[]{"function SearchConstructor() {\n\tthis." + this.getName() + " = 5;\n" + "\tthis." + this.getName() + "XYZ = 10;\n" + "};"}, 4, 0, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testFieldDeclarationSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "SearchConstructor." + this.getName(), new String[]{"X.js"}, new String[]{"function SearchConstructor() {\n\tthis." + this.getName() + " = 5;\n" + "};\n" + "function SearchConstructor2() {\n" + "\tthis." + this.getName() + " = 5;\n" + "};"}, 4, 0, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testFieldDeclarationSearch04() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), String.valueOf(this.getName()) + "XYZ", new String[]{"X.js"}, new String[]{"function SearchConstructor() {\n\tthis." + this.getName() + " = 5;\n" + "};\n" + "SearchConstructor." + this.getName().toUpperCase() + "XYZ = 10;\n"}, 4, 0, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testFieldDeclarationSearch05() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testField*", new String[]{"X.js"}, new String[]{"var searchField = {\n\t" + this.getName() + ": 5,\n" + "\t" + this.getName() + "XYZ: 10,\n" + "};\n"}, 4, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testFieldDeclarationSearch06() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "*." + this.getName().toUpperCase(), new String[]{"X.js"}, new String[]{"function SearchConstructor() {\n\tthis." + this.getName() + " = 5;\n" + "\tthis." + this.getName() + "XYZ = 10;\n" + "};"}, 4, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    @Ignore(value="Prototype is not handled well by ASTParser")
    public void testFieldDeclarationSearch07() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "SearchConstructor.*", new String[]{"X.js"}, new String[]{"SearchConstructor.prototype." + this.getName() + " = 5;\n" + "SearchConstructor.prototype." + this.getName() + "XYZ = 10;\n"}, 4, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    @Ignore(value="Cross file references are not implemented")
    public void testFieldReferenceSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"var searchField = {};\nsearchField." + this.getName() + " = 5;\n" + "searchField." + this.getName() + "XYZ = 10;\n", "var a = searchField." + this.getName() + ";\n"}, 4, 2, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    @Ignore(value="Cross file references are not implemented")
    public void testFieldReferenceSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testfield*", new String[]{"X.js", "Y.js"}, new String[]{"function searchField() {\n\tthis." + this.getName().toUpperCase() + " = 5;\n" + "\tthis." + this.getName() + "XYZ = 10;\n" + "};\n", "var a = searchField." + this.getName().toUpperCase() + ";\n" + "var b = searchField." + this.getName() + "XYZ;\n"}, 4, 2, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    @Ignore(value="Cross file references are not implemented")
    public void testFieldReferenceSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "tFRS", new String[]{"X.js", "Y.js"}, new String[]{"function searchField() {\n\tthis." + this.getName().toUpperCase() + " = 5;\n" + "\tthis." + this.getName() + "XYZ = 10;\n" + "};\n", "var a = searchField." + this.getName().toUpperCase() + ";\n" + "var b = searchField." + this.getName() + "XYZ;\n"}, 4, 2, 128);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testFieldOccurrencesSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "TESTFIELD*", new String[]{"X.js", "Y.js"}, new String[]{"function searchField() {\n\tthis." + this.getName().toUpperCase() + " = 5;\n" + "\tthis." + this.getName() + "XYZ = 10;\n" + "};\n", "var a = searchField." + this.getName().toUpperCase() + ";\n" + "var b = searchField." + this.getName() + "XYZ;\n"}, 4, 3, 10);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }
}

