/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.internal.runtime;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.JSRunnerConfiguration;

public class TestJSRunner
implements IJSRunner {
    private IJSRuntimeInstall jsRuntimeInstall;

    public TestJSRunner(IJSRuntimeInstall jsRuntimeInstall) {
        this.jsRuntimeInstall = jsRuntimeInstall;
    }

    public IProcess run(JSRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.jsRuntimeInstall.getInstallLocation().getPath());
        String[] runtimeArguments = this.combineRuntimeArgs(configuration, this.jsRuntimeInstall);
        if (runtimeArguments.length != 0) {
            String[] stringArray = runtimeArguments;
            int n = runtimeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                cmdLine.add(argument);
                ++n2;
            }
        }
        String mainFile = configuration.getFileToLaunch();
        cmdLine.add(mainFile);
        String[] appArguments = configuration.getProgramArguments();
        if (appArguments.length != 0) {
            String[] stringArray = appArguments;
            int n = appArguments.length;
            int n3 = 0;
            while (n3 < n) {
                String argument = stringArray[n3];
                cmdLine.add(argument);
                ++n3;
            }
        }
        File workingPath = null;
        String workingDirectory = configuration.getWorkingDirectory();
        if (workingDirectory.length() > 0) {
            workingPath = new File(workingDirectory);
        }
        String[] cmds = new String[]{};
        cmds = cmdLine.toArray(cmds);
        ProcessBuilder builder = new ProcessBuilder(cmds);
        builder.directory(workingPath);
        try {
            Process process = builder.start();
            builder.redirectErrorStream(true);
            return DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)"Runtime test process");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String[] combineRuntimeArgs(JSRunnerConfiguration configuration, IJSRuntimeInstall vmInstall) {
        String[] launchVMArgs = configuration.getJSRuntimeArguments();
        String[] vmVMArgs = vmInstall.getJSRuntimeArguments();
        if (vmVMArgs == null || vmVMArgs.length == 0) {
            return launchVMArgs;
        }
        String[] allVMArgs = new String[launchVMArgs.length + vmVMArgs.length];
        System.arraycopy(vmVMArgs, 0, allVMArgs, 0, vmVMArgs.length);
        System.arraycopy(launchVMArgs, 0, allVMArgs, vmVMArgs.length, launchVMArgs.length);
        return allVMArgs;
    }
}

