/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CMValidatorValidationTest
extends TestCase {
    private final String PROJECT_NAME = "CMValidatorTestProject";
    private final String ZIP_FILE_NAME = "CMValidatorTestProject.zip";

    protected void setUp() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "CMValidatorTestProject.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("CMValidatorTestProject");
    }

    public void testGetInsertActions() {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("CMValidatorTestProject/CMValidatorTestSchema.xml"));
        IModelManager modelManager = StructuredModelManager.getModelManager();
        try {
            IStructuredModel model = modelManager.getModelForRead(file);
            IDOMDocument document = ((IDOMModel)model).getDocument();
            Element documentElement = document.getDocumentElement();
            this.verify(documentElement, new String[]{"a"});
            Element aElement = document.createElement("a");
            documentElement.appendChild(aElement);
            this.verify(documentElement, new String[]{"b"});
            Element bElement = document.createElement("b");
            documentElement.appendChild(bElement);
            this.verify(documentElement, new String[]{"d", "c"});
            Element cElement = document.createElement("c");
            documentElement.appendChild(cElement);
            this.verify(documentElement, new String[0]);
            documentElement.removeChild(cElement);
            this.verify(documentElement, new String[]{"d", "c"});
            Element dElement = document.createElement("d");
            documentElement.appendChild(dElement);
            this.verify(documentElement, new String[0]);
            this.verify(aElement, new String[]{"a1"});
            aElement.appendChild(document.createElement("a1"));
            this.verify(aElement, new String[]{"a1"});
            this.verify(bElement, new String[]{"b1"});
            bElement.appendChild(document.createElement("b1"));
            this.verify(bElement, new String[]{"b1"});
            bElement.appendChild(document.createElement("b1"));
            this.verify(bElement, new String[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void verify(Element parentElement, String[] childElementsAvailable) {
        ArrayList list = new ArrayList();
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)parentElement.getOwnerDocument());
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(parentElement);
        modelQuery.getInsertActions(parentElement, cmElementDeclaration, -1, 2, 2, list);
        CMValidatorValidationTest.assertEquals((int)childElementsAvailable.length, (int)list.size());
        ArrayList<String> availableNodeNameList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            availableNodeNameList.add(((ModelQueryAction)iterator.next()).getCMNode().getNodeName());
        }
        int i = 0;
        while (i < childElementsAvailable.length) {
            if (availableNodeNameList.indexOf(childElementsAvailable[i]) == -1) {
                CMValidatorValidationTest.fail();
            }
            ++i;
        }
    }
}

