/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionList;

public class CPPASTConstructorInitializer
extends ASTNode
implements ICPPASTConstructorInitializer,
IASTAmbiguityParent {
    private IASTInitializerClause[] fArguments;

    public CPPASTConstructorInitializer() {
        this.setArguments(null);
    }

    public CPPASTConstructorInitializer(IASTInitializerClause[] args) {
        this.setArguments(args);
    }

    @Override
    public CPPASTConstructorInitializer copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTConstructorInitializer copy(IASTNode.CopyStyle style) {
        IASTInitializerClause[] args = null;
        if (this.fArguments != null) {
            args = new IASTInitializerClause[this.fArguments.length];
            int i = 0;
            while (i < this.fArguments.length) {
                args[i] = this.fArguments[i].copy(style);
                ++i;
            }
        }
        CPPASTConstructorInitializer copy = new CPPASTConstructorInitializer(args);
        return this.copy(copy, style);
    }

    @Override
    public IASTInitializerClause[] getArguments() {
        return this.fArguments;
    }

    @Override
    public void setArguments(IASTInitializerClause[] arguments) {
        this.assertNotFrozen();
        if (arguments == null) {
            this.fArguments = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        } else {
            this.fArguments = arguments;
            IASTInitializerClause[] iASTInitializerClauseArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                arg.setParent(this);
                arg.setPropertyInParent(ARGUMENT);
                ++n2;
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTInitializerClause[] iASTInitializerClauseArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (!arg.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitInitializers || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        int i = 0;
        while (i < this.fArguments.length) {
            if (child == this.fArguments[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.fArguments[i] = (IASTExpression)other;
            }
            ++i;
        }
    }

    @Override
    @Deprecated
    public IASTExpression getExpression() {
        if (this.fArguments.length == 0) {
            return null;
        }
        if (this.fArguments.length == 1) {
            IASTInitializerClause arg = this.fArguments[0];
            if (arg instanceof IASTExpression) {
                return (IASTExpression)arg;
            }
            return null;
        }
        CPPASTExpressionList result = new CPPASTExpressionList();
        IASTInitializerClause[] iASTInitializerClauseArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (arg instanceof IASTExpression) {
                result.addExpression(((IASTExpression)arg).copy());
            }
            ++n2;
        }
        result.setParent(this);
        result.setPropertyInParent(EXPRESSION);
        return result;
    }

    @Override
    @Deprecated
    public void setExpression(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression == null) {
            this.setArguments(null);
        } else if (expression instanceof ICPPASTExpressionList) {
            this.setArguments(((ICPPASTExpressionList)expression).getExpressions());
        } else {
            this.setArguments(new IASTExpression[]{expression});
        }
    }
}

