/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class BaseExtensionPointHandle
extends Handle
implements IExtensionPoint {
    public BaseExtensionPointHandle(IObjectManager objectManager, int id) {
        super(objectManager, id);
    }

    @Override
    public IExtension[] getExtensions() {
        return (IExtension[])this.objectManager.getHandles(this.getExtensionPoint().getRawChildren(), (byte)2);
    }

    @Override
    public String getNamespace() {
        return this.getContributor().getName();
    }

    @Override
    public String getNamespaceIdentifier() {
        return this.getExtensionPoint().getNamespace();
    }

    @Override
    public IContributor getContributor() {
        return this.getExtensionPoint().getContributor();
    }

    protected boolean shouldPersist() {
        return this.getExtensionPoint().shouldPersist();
    }

    @Override
    public IExtension getExtension(String extensionId) {
        if (extensionId == null) {
            return null;
        }
        int[] nArray = this.getExtensionPoint().getRawChildren();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (extensionId.equals(((Extension)this.objectManager.getObject(element, (byte)2)).getUniqueIdentifier())) {
                return (ExtensionHandle)this.objectManager.getHandle(element, (byte)2);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IConfigurationElement[] getConfigurationElements() {
        Extension[] tmpExtensions = (Extension[])this.objectManager.getObjects(this.getExtensionPoint().getRawChildren(), (byte)2);
        if (tmpExtensions.length == 0) {
            return ConfigurationElementHandle.EMPTY_ARRAY;
        }
        ArrayList<Handle> result = new ArrayList<Handle>();
        Extension[] extensionArray = tmpExtensions;
        int n = tmpExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            Extension tmpExtension = extensionArray[n2];
            result.addAll(Arrays.asList(this.objectManager.getHandles(tmpExtension.getRawChildren(), (byte)1)));
            ++n2;
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    public String getLabelAsIs() {
        return this.getExtensionPoint().getLabelAsIs();
    }

    @Override
    public String getLabel() {
        return this.getExtensionPoint().getLabel();
    }

    @Override
    public String getLabel(String locale) {
        return this.getExtensionPoint().getLabel(locale);
    }

    @Override
    public String getSchemaReference() {
        return this.getExtensionPoint().getSchemaReference();
    }

    @Override
    public String getSimpleIdentifier() {
        return this.getExtensionPoint().getSimpleIdentifier();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.getExtensionPoint().getUniqueIdentifier();
    }

    @Override
    RegistryObject getObject() {
        return this.getExtensionPoint();
    }

    protected ExtensionPoint getExtensionPoint() {
        return (ExtensionPoint)this.objectManager.getObject(this.getId(), (byte)3);
    }

    @Override
    public boolean isValid() {
        try {
            this.getExtensionPoint();
        }
        catch (InvalidRegistryObjectException e) {
            return false;
        }
        return true;
    }
}

