/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.aspects;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.aspects.ThreadNameAspect;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class AnalysisThreadNameAspect
extends ThreadNameAspect {
    private static final AnalysisThreadNameAspect INSTANCE = new AnalysisThreadNameAspect();

    private AnalysisThreadNameAspect() {
    }

    public static AnalysisThreadNameAspect getInstance() {
        return INSTANCE;
    }

    public @Nullable String resolve(@NonNull ITmfEvent event) {
        Object pidObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (pidObj == null) {
            return null;
        }
        String hostId = event.getTrace().getHostId();
        IHostModel model = ModelManager.getModelFor((String)hostId);
        Integer tid = (Integer)pidObj;
        ITmfTimestamp timestamp = event.getTimestamp();
        String tname = model.getExecName(tid.intValue(), timestamp.getValue());
        return tname;
    }
}

