/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeBackendIterator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeFactory;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(HistoryTreeBackend.class);
    private final @NonNull String fSsid;
    private final @NonNull IHistoryTree fSht;
    private volatile boolean fFinishedBuilding = false;

    protected boolean isFinishedBuilding() {
        return this.fFinishedBuilding;
    }

    protected void setFinishedBuilding(boolean isFinishedBuilding) {
        this.fFinishedBuilding = isFinishedBuilding;
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime, int blockSize, int maxChildren) throws IOException {
        this.fSsid = ssid;
        HTConfig conf = new HTConfig(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.fSht = this.initializeSHT(conf);
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime) throws IOException {
        this(ssid, newStateFile, providerVersion, startTime, 65536, 50);
    }

    public HistoryTreeBackend(@NonNull String ssid, @NonNull File existingStateFile, int providerVersion) throws IOException {
        this.fSsid = ssid;
        this.fSht = this.initializeSHT(existingStateFile, providerVersion);
        this.fFinishedBuilding = true;
    }

    @VisibleForTesting
    protected @NonNull IHistoryTree initializeSHT(@NonNull HTConfig conf) throws IOException {
        LogUtils.traceObjectCreation((Logger)LOGGER, (Level)Level.FINER, (Object)this);
        return HistoryTreeFactory.createHistoryTree(conf);
    }

    @VisibleForTesting
    protected @NonNull IHistoryTree initializeSHT(@NonNull File existingStateFile, int providerVersion) throws IOException {
        return HistoryTreeFactory.createFromFile(existingStateFile.toPath(), providerVersion);
    }

    protected final @NonNull IHistoryTree getSHT() {
        return this.fSht;
    }

    @Override
    public String getSSID() {
        return this.fSsid;
    }

    @Override
    public long getStartTime() {
        return this.getSHT().getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.getSHT().getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, Object value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, value);
        this.getSHT().insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.getSHT().closeTree(endTime);
        this.fFinishedBuilding = true;
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.getSHT().supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.getSHT().supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.getSHT().supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.getSHT().deleteFile();
    }

    @Override
    public void dispose() {
        if (this.fFinishedBuilding) {
            LogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"HistoryTreeBackend:ClosingFile", (Object[])new Object[]{"size", this.getSHT().getFileSize()});
            LogUtils.traceObjectDestruction((Logger)LOGGER, (Level)Level.FINER, (Object)this);
            this.getSHT().closeFile();
        } else {
            this.getSHT().deleteFile();
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        queue.add(this.getSHT().getRootNode().getSequenceNumber());
        try {
            while (!queue.isEmpty()) {
                int sequenceNumber = (Integer)queue.pop();
                HTNode currentNode = this.getSHT().readNode(sequenceNumber);
                if (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                    queue.addAll(((ParentNode)currentNode).selectNextChildren(t));
                }
                currentNode.writeInfoFromNode(stateInfo, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        try {
            return this.getRelevantInterval(t, attributeQuark);
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    private void checkValidTime(long t) {
        long startTime = this.getStartTime();
        long endTime = this.getEndTime();
        if (t < startTime || t > endTime) {
            throw new TimeRangeException(String.format("%s Time:%d, Start:%d, End:%d", this.fSsid, t, startTime, endTime));
        }
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException, ClosedChannelException {
        this.checkValidTime(t);
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        queue.add(this.getSHT().getRootNode().getSequenceNumber());
        HTInterval interval = null;
        while (interval == null && !queue.isEmpty()) {
            int sequenceNumber = (Integer)queue.pop();
            HTNode currentNode = this.getSHT().readNode(sequenceNumber);
            if (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                queue.addAll(((ParentNode)currentNode).selectNextChildren(t, key));
            }
            interval = currentNode.getRelevantInterval(key, t);
        }
        return interval;
    }

    @Override
    public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarks, TimeRangeCondition times) {
        return this.query2D(quarks, times, false);
    }

    @Override
    public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarks, TimeRangeCondition times, boolean reverse) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (LogUtils.FlowScopeLog log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINER, "HistoryTreeBackend:query2D:init", new Object[]{"ssid", this.getSSID(), "quarks", quarks, "timeCondition", times}).build();){
            return () -> new HistoryTreeBackendIterator(this.getSHT(), quarks, times, reverse, Objects.requireNonNull(log));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public long getFileSize() {
        return this.getSHT().getFileSize();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.getSHT().getNodeCount()) {
                HTNode node = this.getSHT().readNode(seq);
                total += node.getNodeUsagePercent();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        long ret = total / (long)this.getSHT().getNodeCount();
        if (ret < 0L || ret > 100L) {
            throw new IllegalStateException("Average node usage is not a percentage: " + ret);
        }
        return (int)ret;
    }
}

