/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.CpuFrequencyHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.IPIEntryHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.IPIExitHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.IrqEntryHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.IrqExitHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.PiSetprioHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.ProcessExitHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.ProcessForkHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.ProcessFreeHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SchedMigrateTaskHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SchedSwitchHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SchedWakeupHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SoftIrqEntryHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SoftIrqExitHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SoftIrqRaiseHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.StateDumpHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SysEntryHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.SysExitHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class KernelStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 31;
    private final Map<String, KernelEventHandler> fEventNames;
    private final IKernelAnalysisEventLayout fLayout;
    private final KernelEventHandler fSysEntryHandler;
    private final KernelEventHandler fSysExitHandler;

    public KernelStateProvider(ITmfTrace trace, IKernelAnalysisEventLayout layout) {
        super(trace, "Kernel");
        this.fLayout = layout;
        this.fEventNames = KernelStateProvider.buildEventNames(layout);
        this.fSysEntryHandler = new SysEntryHandler(this.fLayout);
        this.fSysExitHandler = new SysExitHandler(this.fLayout);
    }

    private static Map<String, KernelEventHandler> buildEventNames(IKernelAnalysisEventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventIrqHandlerEntry(), (Object)new IrqEntryHandler(layout));
        builder.put((Object)layout.eventIrqHandlerExit(), (Object)new IrqExitHandler(layout));
        builder.put((Object)layout.eventSoftIrqEntry(), (Object)new SoftIrqEntryHandler(layout));
        builder.put((Object)layout.eventSoftIrqExit(), (Object)new SoftIrqExitHandler(layout));
        builder.put((Object)layout.eventSoftIrqRaise(), (Object)new SoftIrqRaiseHandler(layout));
        builder.put((Object)layout.eventSchedSwitch(), (Object)new SchedSwitchHandler(layout));
        builder.put((Object)layout.eventSchedPiSetprio(), (Object)new PiSetprioHandler(layout));
        builder.put((Object)layout.eventSchedProcessFork(), (Object)new ProcessForkHandler(layout));
        builder.put((Object)layout.eventSchedProcessExit(), (Object)new ProcessExitHandler(layout));
        builder.put((Object)layout.eventSchedProcessFree(), (Object)new ProcessFreeHandler(layout));
        builder.put((Object)layout.eventSchedProcessWaking(), (Object)new SchedWakeupHandler(layout));
        builder.put((Object)layout.eventSchedMigrateTask(), (Object)new SchedMigrateTaskHandler(layout));
        builder.put((Object)layout.eventCpuFrequency(), (Object)new CpuFrequencyHandler(layout));
        for (String s : layout.getIPIIrqVectorsEntries()) {
            builder.put((Object)s, (Object)new IPIEntryHandler(layout));
        }
        for (String s : layout.getIPIIrqVectorsExits()) {
            builder.put((Object)s, (Object)new IPIExitHandler(layout));
        }
        String eventStatedumpProcessState = layout.eventStatedumpProcessState();
        if (eventStatedumpProcessState != null) {
            builder.put((Object)eventStatedumpProcessState, (Object)new StateDumpHandler(layout));
        }
        for (String eventSchedWakeup : layout.eventsSchedWakeup()) {
            builder.put((Object)eventSchedWakeup, (Object)new SchedWakeupHandler(layout));
        }
        return builder.build();
    }

    public int getVersion() {
        return 31;
    }

    public KernelStateProvider getNewInstance() {
        return new KernelStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(@Nullable ITmfEvent event) {
        if (event == null) {
            return;
        }
        String eventName = event.getName();
        try {
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            KernelEventHandler handler = this.fEventNames.get(eventName);
            if (handler == null) {
                if (this.isSyscallExit(eventName)) {
                    handler = this.fSysExitHandler;
                } else if (this.isSyscallEntry(eventName)) {
                    handler = this.fSysEntryHandler;
                }
            }
            if (handler != null) {
                handler.handleEvent(ss, event);
            }
        }
        catch (AttributeNotFoundException ae) {
            Activator.getDefault().logError("Attribute not found: " + ae.getMessage(), ae);
        }
        catch (TimeRangeException tre) {
            Activator.getDefault().logError("TimeRangeExcpetion caught in the state system's event manager.\nAre the events in the trace correctly ordered?\n" + tre.getMessage(), tre);
        }
        catch (StateValueTypeException sve) {
            Activator.getDefault().logError("State value error: " + sve.getMessage(), sve);
        }
    }

    private boolean isSyscallEntry(String eventName) {
        return eventName.startsWith(this.fLayout.eventSyscallEntryPrefix()) || eventName.startsWith(this.fLayout.eventCompatSyscallEntryPrefix());
    }

    private boolean isSyscallExit(String eventName) {
        return eventName.startsWith(this.fLayout.eventSyscallExitPrefix()) || eventName.startsWith(this.fLayout.eventCompatSyscallExitPrefix());
    }
}

