/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplate;

public class CPPClassTemplatePartialSpecialization
extends CPPClassTemplate
implements ICPPClassTemplatePartialSpecialization {
    private final ICPPTemplateArgument[] arguments;

    public CPPClassTemplatePartialSpecialization(ICPPASTTemplateId name, ICPPTemplateArgument[] arguments) {
        super(name);
        this.arguments = arguments;
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.arguments;
    }

    @Override
    public ICPPClassTemplate getPrimaryClassTemplate() {
        ICPPASTTemplateId id = (ICPPASTTemplateId)this.getTemplateName();
        return (ICPPClassTemplate)id.getTemplateName().resolveBinding();
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        if (type instanceof ICPPClassTemplatePartialSpecialization) {
            return CPPClassTemplatePartialSpecialization.isSamePartialClassSpecialization(this, (ICPPClassTemplatePartialSpecialization)type);
        }
        return false;
    }

    public static boolean isSamePartialClassSpecialization(ICPPClassTemplatePartialSpecialization lhs, ICPPClassTemplatePartialSpecialization rhs) {
        ICPPTemplateArgument[] args2;
        ICPPClassTemplate ct2;
        ICPPClassTemplate ct1 = lhs.getPrimaryClassTemplate();
        if (!ct1.isSameType(ct2 = rhs.getPrimaryClassTemplate())) {
            return false;
        }
        ICPPTemplateArgument[] args1 = lhs.getTemplateArguments();
        if (args1.length != (args2 = rhs.getTemplateArguments()).length) {
            return false;
        }
        int i = 0;
        while (i < args2.length) {
            if (!args1[i].isSameValue(args2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + ASTTypeUtil.getArgumentListString(this.getTemplateArguments(), true);
    }

    @Override
    public ICPPTemplateDefinition getPrimaryTemplate() {
        return this.getPrimaryClassTemplate();
    }
}

