/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core.impl;

import java.io.Serializable;

public final class TimeValuePair implements Comparable<TimeValuePair>, Serializable {
    private static final long serialVersionUID = 5844953903559822145L;

    private final double time;

    private final double value;

    public TimeValuePair(double time, double value) {
        this.time = time;
        this.value = value;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Double.hashCode(time);
        result = prime * result + Double.hashCode(value);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TimeValuePair)) {
            return false;
        }
        TimeValuePair tvp = (TimeValuePair)o;
        return time == tvp.time && value == tvp.value;
    }

    @Override
    public int compareTo(TimeValuePair o) {
        int result = Double.compare(time, o.time);
        if (result == 0) {
            result = Double.compare(value, o.value);
        }
        return result;
    }

    public double getTime() {
        return time;
    }

    public double getValue() {
        return value;
    }
}
