/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.dist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.Dependency;

public class DependencyInclusionCheck {
    private DependencyInclusionCheck() {
    }

    public static List<IDependency> check(ITrace modelTrace, ITrace systemTrace, String weightAttribute) {
        if (modelTrace.getTimeUnit() != systemTrace.getTimeUnit()) {
            throw new IllegalArgumentException("traces must use the same time unit");
        }
        ArrayList<IDependency> systemDependencies = new ArrayList<IDependency>();
        HashMap<IEvent, IEvent> cache = new HashMap<IEvent, IEvent>();
        for (IDependency d : modelTrace.getDependencies()) {
            IEvent e1 = DependencyInclusionCheck.get(cache, d.getSrc(), systemTrace);
            IEvent e2 = DependencyInclusionCheck.get(cache, d.getDst(), systemTrace);
            if (e1 == null || e2 == null) continue;
            double weight = DependencyInclusionCheck.getWeightFromAttribute(d, weightAttribute);
            if (!(e1.getTimestamp().doubleValue() + weight > e2.getTimestamp().doubleValue())) continue;
            Dependency annotatedDep = new Dependency(e1, e2);
            annotatedDep.setAttribute(weightAttribute, Double.toString(weight));
            systemDependencies.add(annotatedDep);
        }
        return systemDependencies;
    }

    private static double getWeightFromAttribute(IDependency d, String weightAttribute) {
        if (weightAttribute == null) {
            return 0.0;
        }
        String w = d.getAttributeValue(weightAttribute);
        if (w != null) {
            try {
                return Double.parseDouble(w);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    private static IEvent get(Map<IEvent, IEvent> cache, IEvent modelEvent, ITrace systemTrace) {
        IEvent r = cache.get(modelEvent);
        if (r != null) {
            return r;
        }
        for (IEvent sysEvent : systemTrace.getEvents()) {
            if (!DependencyInclusionCheck.eventTypeEquals(modelEvent, sysEvent) || !modelEvent.getAttributes().equals(sysEvent.getAttributes())) continue;
            cache.put(modelEvent, sysEvent);
            return sysEvent;
        }
        return null;
    }

    private static boolean eventTypeEquals(IEvent lsatEvent, IEvent sysEvent) {
        if (lsatEvent instanceof IClaimEvent && !(sysEvent instanceof IClaimEvent)) {
            return false;
        }
        if (!(lsatEvent instanceof IClaimEvent) && sysEvent instanceof IClaimEvent) {
            return false;
        }
        return !(lsatEvent instanceof IClaimEvent) || !(sysEvent instanceof IClaimEvent) || ((IClaimEvent)lsatEvent).getType() == ((IClaimEvent)sysEvent).getType();
    }
}

