/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class RegexValidator
extends Validator {
    public static final int ATTR_NOT_REGEX = 2;
    public static final String INFO_MISSING_VALUE = "RegexValidator_Information_MissingValue";
    public static final String ERROR_INVALID_VALUE = "RegexValidator_Error_InvalidValue";
    private String regex;

    public RegexValidator(int attributes, String regex) {
        super(attributes);
        this.regex = regex;
    }

    @Override
    public boolean isValid(String newText) {
        this.init();
        if (newText == null || newText.trim().length() == 0) {
            if (this.isMandatory()) {
                this.setMessage(this.getMessageText(INFO_MISSING_VALUE), this.getMessageTextType(INFO_MISSING_VALUE, 1));
                return false;
            }
            return true;
        }
        boolean match = newText.matches(this.regex);
        if (!this.isAttribute(2) && !match || this.isAttribute(2) && match) {
            this.setMessage(this.getMessageText(ERROR_INVALID_VALUE), this.getMessageTextType(ERROR_INVALID_VALUE, 3));
            return this.getMessageType() != 3;
        }
        return true;
    }

    protected String getRegularExpression() {
        return this.regex;
    }

    protected void setRegularExpression(String regex) {
        this.regex = regex != null && regex.length() > 0 ? regex : ".*";
    }
}

