/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.controls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.TreeContentProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public abstract class NavigatorContentProvider
extends TreeContentProvider {
    private Set<IRuntimeModel> fModelsWithOpenFavorites = new HashSet<IRuntimeModel>();

    public Object getParent(Object element) {
        if (element instanceof IFSTreeNode) {
            IFSTreeNode node = (IFSTreeNode)element;
            IFSTreeNode parent = node.getParent();
            if (parent != null) {
                if (parent.isFileSystem()) {
                    if (this.isRootNodeVisible()) {
                        return parent;
                    }
                    return null;
                }
                return parent;
            }
            if (this.isRootNodeVisible()) {
                return node.getPeerNode();
            }
        }
        return null;
    }

    private void checkOpenFavorites(IRuntimeModel rtm) {
        if (!this.fModelsWithOpenFavorites.add(rtm)) {
            return;
        }
        final IResultOperation operation = rtm.operationRestoreFavorites();
        operation.runInJob((ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                IFSTreeNode[] nodes = (IFSTreeNode[])operation.getResult();
                if (nodes != null) {
                    final ArrayList<IFSTreeNode> expandMe = new ArrayList<IFSTreeNode>();
                    IFSTreeNode[] iFSTreeNodeArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFSTreeNode node = iFSTreeNodeArray[n2];
                        while ((node = node.getParent()) != null) {
                            expandMe.add(node);
                        }
                        ++n2;
                    }
                    Collections.reverse(expandMe);
                    NavigatorContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HashSet<IFSTreeNode> handled = new HashSet<IFSTreeNode>();
                            for (IFSTreeNode n : expandMe) {
                                if (!handled.add(n)) continue;
                                (this).NavigatorContentProvider.this.viewer.setExpandedState((Object)n, true);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        super.getChildren(parentElement);
        if (parentElement instanceof IPeerNode) {
            IPeerNode peerNode = (IPeerNode)parentElement;
            IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)peerNode);
            if (model == null) {
                return NO_ELEMENTS;
            }
            this.checkOpenFavorites(model);
            if (this.isRootNodeVisible()) {
                IFSTreeNode root = model.getRoot();
                return new Object[]{root};
            }
            return this.getChildren(model.getRoot());
        }
        if (parentElement instanceof IFSTreeNode) {
            IFSTreeNode node = (IFSTreeNode)parentElement;
            this.checkOpenFavorites(node.getRuntimeModel());
            if (!node.isDirectory() && !node.isFileSystem()) {
                return NO_ELEMENTS;
            }
            Object[] children = node.getChildren();
            if (children == null) {
                node.operationRefresh(false).runInJob(null);
                return new Object[]{this.getPending(node)};
            }
            return children;
        }
        return NO_ELEMENTS;
    }

    @Override
    public boolean hasChildren(Object element) {
        Assert.isNotNull((Object)element);
        if (element instanceof IFSTreeNode) {
            IFSTreeNode node = (IFSTreeNode)element;
            if (node.isFileSystem() || node.isDirectory()) {
                return node.getChildren() == null || super.hasChildren(element);
            }
            return false;
        }
        if (element instanceof IPeerNode) {
            IPeerNode peerNode = (IPeerNode)element;
            IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)peerNode);
            return model != null;
        }
        return false;
    }

    protected boolean isRootNodeVisible() {
        return true;
    }
}

