/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.adapters;

import java.util.Collection;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenContextQuery;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.protocol.Protocol;

class TCFLaunchLabelProvider
implements IElementLabelProvider {
    TCFLaunchLabelProvider() {
    }

    public void update(ILabelUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            String view_id = updates[i].getPresentationContext().getId();
            if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
                this.updateContextQueryViewLabel(updates[i]);
            } else {
                this.updateDebugViewLabel(updates[i]);
            }
            ++i;
        }
    }

    private void updateDebugViewLabel(ILabelUpdate result) {
        Throwable error;
        TCFLaunch launch = (TCFLaunch)result.getElement();
        ImageDescriptor image = DebugUITools.getDefaultImageDescriptor((Object)launch);
        if (image == null) {
            image = ImageCache.getImageDescriptor("icons/tcf");
        }
        result.setImageDescriptor(image, 0);
        String status = "";
        if (launch.isConnecting()) {
            status = "Connecting";
        } else if (launch.isDisconnected()) {
            status = "Disconnected";
        }
        String peer_name = launch.getPeerName();
        if (peer_name != null) {
            status = status.length() == 0 ? peer_name : String.valueOf(peer_name) + ": " + status;
        }
        if (status.length() > 0) {
            status = " (" + status + ")";
        }
        if ((error = launch.getError()) != null) {
            status = String.valueOf(status) + ": " + TCFModel.getErrorMessage(error, false);
            result.setForeground(ColorCache.rgb_error, 0);
        } else if (launch.isExited()) {
            status = String.valueOf(status) + ": All exited or detached";
            int code = launch.getExitCode();
            if (code > 0) {
                status = String.valueOf(status) + ", exit code " + code;
            }
            if (code < 0) {
                status = String.valueOf(status) + ", signal " + -code;
                Collection sigs = launch.getSignalList();
                if (sigs != null) {
                    for (Map m : sigs) {
                        String s;
                        Number num = (Number)m.get("Code");
                        if (num == null || num.intValue() != -code || (s = (String)m.get("Name")) == null) continue;
                        status = String.valueOf(status) + " (" + s + ")";
                        break;
                    }
                }
            }
        }
        String name = "?";
        ILaunchConfiguration cfg = launch.getLaunchConfiguration();
        if (cfg != null) {
            name = cfg.getName();
        }
        result.setLabel(String.valueOf(name) + status, 0);
        result.done();
    }

    private void updateContextQueryViewLabel(final ILabelUpdate result) {
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ILaunchConfiguration cfg;
                TCFLaunch launch = (TCFLaunch)result.getElement();
                ImageDescriptor image = DebugUITools.getDefaultImageDescriptor((Object)launch);
                if (image == null) {
                    image = ImageCache.getImageDescriptor("icons/tcf");
                }
                result.setImageDescriptor(image, 0);
                StringBuffer label = new StringBuffer();
                TCFModel model = TCFModelManager.getModelManager().getModel(launch);
                if (model != null && model.getRootNode() != null) {
                    TCFChildrenContextQuery.Descendants des = TCFChildrenContextQuery.getDescendants(model.getRootNode(), (IViewerUpdate)result, this);
                    if (des == null) {
                        return;
                    }
                    if (des.map != null && des.map.size() > 0) {
                        label.append("(");
                        label.append(des.map.size());
                        label.append(") ");
                    }
                }
                if ((cfg = launch.getLaunchConfiguration()) != null) {
                    label.append(cfg.getName());
                } else {
                    label.append("?");
                }
                String peer_name = launch.getPeerName();
                if (peer_name != null) {
                    label.append(" (");
                    label.append(peer_name);
                    label.append(")");
                }
                result.setLabel(label.toString(), 0);
                result.done();
            }
        });
    }
}

