/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.terminals.ui.launcher;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.ui.IMemento;

public class TerminalsMementoHandler
implements IMementoHandler {
    public void saveState(IMemento memento, Map<String, Object> properties) {
        Object element;
        Assert.isNotNull((Object)memento);
        Assert.isNotNull(properties);
        memento.putString("encoding", (String)properties.get("encoding"));
        ISelection selection = (ISelection)properties.get("selection");
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPeerNode) {
            IPeerNode peerNode = (IPeerNode)element;
            memento.putString("peerID", peerNode.getPeerId());
        }
    }

    public void restoreState(IMemento memento, Map<String, Object> properties) {
        Assert.isNotNull((Object)memento);
        Assert.isNotNull(properties);
        properties.put("encoding", memento.getString("encoding"));
        final String peerID = memento.getString("peerID");
        if (peerID != null) {
            final IPeerModel model = ModelManager.getPeerModel();
            Assert.isNotNull((Object)model);
            final AtomicReference peerNode = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    peerNode.set(((IPeerModelLookupService)model.getService(IPeerModelLookupService.class)).lkupPeerModelById(peerID));
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            if (peerNode.get() == null) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                Protocol.invokeAndWait((Runnable)runnable);
            }
            if (peerNode.get() != null) {
                properties.put("selection", new StructuredSelection(peerNode.get()));
            }
        }
    }
}

