/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.events;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;

public class NotifyEvent
extends EventObject
implements Comparable<NotifyEvent> {
    private static final long serialVersionUID = -7099295102694857196L;
    public static final String PROP_TITLE_TEXT = "titleText";
    public static final String PROP_TITLE_IMAGE_ID = "titleImageId";
    public static final String PROP_DESCRIPTION_TEXT = "descriptionText";
    private final long creationTime = System.nanoTime();
    private final String factoryId;
    private final IPropertiesContainer properties;

    public NotifyEvent(Object source, IPropertiesContainer properties) {
        this(source, null, properties);
    }

    public NotifyEvent(Object source, String factoryId, IPropertiesContainer properties) {
        super(source);
        this.factoryId = factoryId;
        Assert.isNotNull((Object)properties);
        this.properties = properties;
    }

    @Override
    public int compareTo(NotifyEvent o) {
        if (o == null) {
            return 1;
        }
        return Long.valueOf(this.creationTime).compareTo(o.creationTime);
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public IPropertiesContainer getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int hashCode = Long.valueOf(this.creationTime).hashCode();
        if (this.factoryId != null) {
            hashCode ^= this.factoryId.hashCode();
        }
        return hashCode ^= this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NotifyEvent) {
            return this.creationTime == ((NotifyEvent)obj).creationTime && (this.factoryId != null ? this.factoryId.equals(((NotifyEvent)obj).factoryId) : ((NotifyEvent)obj).factoryId == null) && this.properties.equals(((NotifyEvent)obj).properties);
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuffer toString = new StringBuffer(this.getClass().getName());
        String prefix = "";
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/events")) {
            prefix = "\n\t\t";
        }
        toString.append(String.valueOf(prefix) + "{creationTime=");
        toString.append(this.creationTime);
        toString.append("," + prefix + "{factoryId=");
        toString.append(this.factoryId);
        toString.append("," + prefix + "properties=");
        toString.append(this.properties);
        toString.append("," + prefix + "source=");
        toString.append(this.source);
        toString.append("}");
        return toString.toString();
    }
}

