/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.terminals.ui.connector;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ITerminals;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsLauncher;
import org.eclipse.tcf.te.tcf.terminals.ui.connector.TerminalsSettings;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.ui.streams.AbstractStreamsConnector;

public class TerminalsConnector
extends AbstractStreamsConnector
implements IDisposable {
    private final TerminalsSettings settings;
    private int width = -1;
    private int height = -1;

    public TerminalsConnector() {
        this(new TerminalsSettings());
    }

    public TerminalsConnector(TerminalsSettings settings) {
        Assert.isNotNull((Object)settings);
        this.settings = settings;
    }

    public void connect(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        super.connect(control);
        this.connectStreams(control, this.settings.getStdinStream(), this.settings.getStdoutStream(), this.settings.getStderrStream(), this.settings.isLocalEcho(), this.settings.getLineSeparator());
        control.setState(TerminalState.CONNECTED);
    }

    public boolean isLocalEcho() {
        return this.settings.isLocalEcho();
    }

    public void dispose() {
        this.disconnect();
    }

    public void doDisconnect() {
        super.doDisconnect();
        this.fControl.setState(TerminalState.CLOSED);
    }

    public void setTerminalSize(final int newWidth, final int newHeight) {
        if ((this.width == -1 || this.height == -1 || newWidth != this.width || newHeight != this.height) && this.fControl.getState() == TerminalState.CONNECTED && this.settings.getTerminalsLauncher() instanceof TerminalsLauncher) {
            final ITerminals service = ((TerminalsLauncher)this.settings.getTerminalsLauncher()).getSvcTerminals();
            final ITerminals.TerminalContext context = (ITerminals.TerminalContext)this.settings.getTerminalsLauncher().getAdapter(ITerminals.TerminalContext.class);
            if (service != null && context != null) {
                this.width = newWidth;
                this.height = newHeight;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        service.setWinSize(context.getID(), newWidth, newHeight, new ITerminals.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                            }
                        });
                    }
                });
            }
        }
    }

    public String getSettingsSummary() {
        return "";
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }
}

