/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.remote.core.activator.CoreBundleActivator;

public abstract class TCFOperation<R> {
    private IStatus fError;
    private R fResult;
    private boolean fDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean shallAbort(IStatus status) {
        TCFOperation tCFOperation = this;
        synchronized (tCFOperation) {
            block6: {
                block5: {
                    if (!this.fDone) break block5;
                    return true;
                }
                if (status.isOK()) break block6;
                this.setError(status);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean shallAbort(Throwable error) {
        TCFOperation tCFOperation = this;
        synchronized (tCFOperation) {
            block6: {
                block5: {
                    if (!this.fDone) break block5;
                    return true;
                }
                if (error == null) break block6;
                this.setError(error);
                return true;
            }
            return false;
        }
    }

    protected final void setError(Throwable error) {
        this.setError((IStatus)this.createStatus(error.getMessage(), error));
    }

    protected final Status createStatus(String msg, Throwable error) {
        return new Status(4, CoreBundleActivator.getUniqueIdentifier(), msg, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setError(IStatus error) {
        TCFOperation tCFOperation = this;
        synchronized (tCFOperation) {
            this.fError = error;
            this.fDone = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(R result) {
        TCFOperation tCFOperation = this;
        synchronized (tCFOperation) {
            this.fResult = result;
            this.fDone = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected R waitForResult(SubMonitor sm) throws CoreException, InterruptedException, OperationCanceledException {
        TCFOperation tCFOperation = this;
        synchronized (tCFOperation) {
            while (!this.fDone) {
                if (sm.isCanceled()) {
                    this.fDone = true;
                    throw new OperationCanceledException();
                }
                this.wait(1000L);
            }
            if (this.fError != null) {
                throw new CoreException(this.fError);
            }
            return this.fResult;
        }
    }

    public final R execute(SubMonitor sm) throws CoreException, OperationCanceledException {
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TCFOperation.this.doExecute();
            }
        });
        try {
            return this.waitForResult(sm);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new OperationCanceledException();
        }
    }

    protected abstract void doExecute();
}

