/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tcf.debug.ui.ITCFPrettyExpressionProvider;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.internal.debug.ui.model.TCFPrettyExpressionProvider;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFChildrenSubExpressions
extends TCFChildren {
    private final int par_level;
    private final int par_offs;
    private final int par_size;

    TCFChildrenSubExpressions(TCFNode node, int par_level, int par_offs, int par_size) {
        super(node, 128);
        this.par_level = par_level;
        this.par_offs = par_offs;
        this.par_size = par_size;
    }

    void onSuspended(boolean func_call) {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onSuspended(func_call);
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onSuspended(func_call);
        }
    }

    void onValueChanged() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onValueChanged();
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onValueChanged();
        }
    }

    void onRegisterValueChanged() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onRegisterValueChanged();
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onRegisterValueChanged();
        }
    }

    void onMemoryChanged() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onMemoryChanged();
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onMemoryChanged();
        }
    }

    void onMemoryMapChanged() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onMemoryMapChanged();
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onMemoryMapChanged();
        }
    }

    void onCastToTypeChanged() {
        this.cancel();
        TCFNode[] a = this.getNodes().toArray(new TCFNode[this.getNodes().size()]);
        int i = 0;
        while (i < a.length) {
            a[i].dispose();
            ++i;
        }
    }

    TCFNodeExpression getField(String field_id, boolean deref) {
        assert (field_id != null);
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!field_id.equals(e.getFieldID()) || e.isDeref() != deref) continue;
            return e;
        }
        if (this.isValid()) {
            return null;
        }
        TCFNodeExpression e = new TCFNodeExpression(this.node, null, field_id, null, null, -1, deref);
        this.add(e);
        return e;
    }

    private boolean findFields(ISymbols.Symbol type, Map<String, TCFNode> map, boolean deref) {
        TCFDataCache<String[]> children_cache = this.node.model.getSymbolChildrenCache(type.getID());
        if (children_cache == null) {
            return true;
        }
        if (!children_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        String[] children = (String[])children_cache.getData();
        if (children == null) {
            return true;
        }
        TCFDataCache<ISymbols.Symbol> pending = null;
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TCFDataCache<ISymbols.Symbol> sym_cache = this.node.model.getSymbolInfoCache(id);
            if (!sym_cache.validate()) {
                pending = sym_cache;
            } else {
                ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
                if (sym_data != null) {
                    switch (sym_data.getSymbolClass()) {
                        case reference: {
                            if (sym_data.getFlag(131072)) break;
                            if (sym_data.getName() == null && !sym_data.getFlag(0x2000000)) {
                                if (this.findFields(sym_data, map, deref)) break;
                                return false;
                            }
                            TCFNodeExpression n3 = this.getField(id, deref);
                            n3.setSortPosition(map.size());
                            map.put(n3.id, n3);
                            break;
                        }
                        case variant: {
                            if (this.findFields(sym_data, map, deref)) break;
                            return false;
                        }
                        case variant_part: {
                            if (this.node.model.isFilterVariantsByDiscriminant()) {
                                String discr_id = null;
                                int offset = sym_data.getOffset();
                                String[] stringArray2 = children;
                                int n4 = children.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    String id2 = stringArray2[n5];
                                    if (!id.equals(id2)) {
                                        TCFDataCache<ISymbols.Symbol> discr_sym_cache = this.node.model.getSymbolInfoCache(id2);
                                        if (!discr_sym_cache.validate()) {
                                            pending = discr_sym_cache;
                                        } else {
                                            ISymbols.Symbol discr_sym_data = (ISymbols.Symbol)discr_sym_cache.getData();
                                            if (discr_sym_data != null && discr_sym_data.getSymbolClass() != ISymbols.SymbolClass.variant_part && discr_sym_data.getOffset() == offset) {
                                                discr_id = id2;
                                                break;
                                            }
                                        }
                                    }
                                    ++n5;
                                }
                                if (discr_id == null || this.filterVariants(sym_data, map, discr_id, deref)) break;
                                return false;
                            }
                            if (this.findFields(sym_data, map, deref)) break;
                            return false;
                        }
                    }
                }
            }
            ++n2;
        }
        if (pending == null) {
            return true;
        }
        pending.wait((Runnable)((Object)this));
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean filterVariants(ISymbols.Symbol type, Map<String, TCFNode> map, String discr_id, boolean deref) {
        discr_expr = this.getField(discr_id, deref);
        discr_value_cache = discr_expr.getValue();
        if (!discr_value_cache.validate((Runnable)this)) {
            return false;
        }
        discr_value = (IExpressions.Value)discr_value_cache.getData();
        if (discr_value == null) {
            return true;
        }
        discr = TCFNumberFormat.toBigInteger(discr_value.getValue(), discr_value.isBigEndian(), false);
        children_cache = this.node.model.getSymbolChildrenCache(type.getID());
        if (children_cache == null) {
            return true;
        }
        if (!children_cache.validate((Runnable)this)) {
            return false;
        }
        children = (String[])children_cache.getData();
        if (children == null) {
            return true;
        }
        pending /* !! */  = null;
        variant_sym_data = null;
        default_sym_data = null;
        var17_14 = children;
        var16_15 = children.length;
        var15_16 = 0;
        while (var15_16 < var16_15) {
            block17: {
                block16: {
                    block15: {
                        id = var17_14[var15_16];
                        sym_cache = this.node.model.getSymbolInfoCache(id);
                        if (sym_cache.validate()) break block15;
                        pending /* !! */  = sym_cache;
                        break block16;
                    }
                    sym_data = (ISymbols.Symbol)sym_cache.getData();
                    if (sym_data == null) break block17;
                    block0 : switch (TCFChildrenSubExpressions.$SWITCH_TABLE$org$eclipse$tcf$services$ISymbols$SymbolClass()[sym_data.getSymbolClass().ordinal()]) {
                        case 10: {
                            sym_loc_cache = this.node.model.getSymbolLocationCache(id);
                            if (sym_loc_cache.validate()) ** GOTO lbl38
                            pending /* !! */  = sym_loc_cache;
                            break block17;
lbl38:
                            // 1 sources

                            sym_loc_data = (Map)sym_loc_cache.getData();
                            discr_info = sym_loc_data.get("Discriminant");
                            if (discr_info instanceof List) {
                                values = (List)discr_info;
                                for (E value : values) {
                                    if (value instanceof Number) {
                                        val = JSON.toBigInteger((Number)((Number)value));
                                        if (!discr.equals(val)) continue;
                                        variant_sym_data = sym_data;
                                        break block0;
                                    }
                                    if (!(value instanceof Map)) continue;
                                    range = (Map)value;
                                    x = range.get("X");
                                    y = range.get("Y");
                                    if (!(x instanceof Number) || !(y instanceof Number)) continue;
                                    lower = JSON.toBigInteger((Number)((Number)x));
                                    upper = JSON.toBigInteger((Number)((Number)y));
                                    if (discr.compareTo(lower) < 0 || discr.compareTo(upper) > 0) continue;
                                    variant_sym_data = sym_data;
                                    break block0;
                                }
                                break;
                            }
                            if (discr_info != null) break;
                            default_sym_data = sym_data;
                            break;
                        }
                        default: {
                            if (!TCFChildrenSubExpressions.$assertionsDisabled) {
                                throw new AssertionError((Object)("Unexpected symbol class: " + sym_data.getSymbolClass()));
                            }
                            break;
                        }
                    }
                }
                if (variant_sym_data != null) break;
            }
            ++var15_16;
        }
        if (pending /* !! */  != null) {
            pending /* !! */ .wait((Runnable)this);
            return false;
        }
        if (variant_sym_data == null) {
            variant_sym_data = default_sym_data;
        }
        return variant_sym_data == null || this.findFields(variant_sym_data, map, deref) != false;
    }

    private TCFNodeExpression findReg(String reg_id) {
        assert (reg_id != null);
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!reg_id.equals(e.getRegisterID())) continue;
            return e;
        }
        return null;
    }

    private boolean findRegs(TCFNodeRegister reg_node, Map<String, TCFNode> map) {
        TCFChildren reg_children = reg_node.getChildren();
        if (!reg_children.validate((Runnable)((Object)this))) {
            return false;
        }
        TCFNode[] tCFNodeArray = reg_children.toArray();
        int n = tCFNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode subnode = tCFNodeArray[n2];
            TCFNodeExpression n3 = this.findReg(subnode.id);
            if (n3 == null) {
                n3 = new TCFNodeExpression(this.node, null, null, null, subnode.id, -1, false);
                this.add(n3);
            }
            n3.setSortPosition(map.size());
            map.put(n3.id, n3);
            ++n2;
        }
        return true;
    }

    private TCFNodeExpression findIndex(int index, boolean deref) {
        assert (index >= 0);
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (e.getIndex() != index || e.isDeref() != deref) continue;
            return e;
        }
        return null;
    }

    private TCFNodeArrayPartition findPartition(int offs, int size) {
        assert (offs >= 0);
        for (TCFNode n : this.getNodes()) {
            TCFNodeArrayPartition e = (TCFNodeArrayPartition)n;
            if (e.getOffset() != offs || e.getSize() != size) continue;
            return e;
        }
        return null;
    }

    private TCFNodeExpression findScript(String s) {
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e;
            if (!(n instanceof TCFNodeExpression) || !s.equals((e = (TCFNodeExpression)n).getScript())) continue;
            return e;
        }
        return null;
    }

    protected boolean startDataRetrieval() {
        assert (!this.isDisposed());
        TCFNode exp = this.node;
        while (!(exp instanceof TCFNodeExpression)) {
            exp = exp.parent;
        }
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            TCFDataCache<String[]> c = p.getChildren(exp);
            if (c == null) continue;
            if (!c.validate((Runnable)((Object)this))) {
                return false;
            }
            if (c.getError() != null || c.getData() == null) continue;
            int i = 0;
            HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
            String[] stringArray = (String[])c.getData();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                TCFNodeExpression n3 = this.findScript(s);
                if (n3 == null) {
                    n3 = new TCFNodeExpression(this.node, s, null, null, null, -1, false);
                }
                n3.setSortPosition(i++);
                data.put(n3.id, n3);
                ++n2;
            }
            this.set(null, null, data);
            return true;
        }
        TCFDataCache<ISymbols.Symbol> type_cache = ((TCFNodeExpression)exp).getType();
        if (!type_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        ISymbols.Symbol type_data = (ISymbols.Symbol)type_cache.getData();
        if (type_data == null) {
            String reg_id;
            HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
            TCFDataCache<IExpressions.Value> val_cache = ((TCFNodeExpression)exp).getValue();
            if (!val_cache.validate((Runnable)((Object)this))) {
                return false;
            }
            IExpressions.Value val_data = (IExpressions.Value)val_cache.getData();
            if (val_data != null && (reg_id = val_data.getRegisterID()) != null) {
                if (!this.node.model.createNode(reg_id, (Runnable)((Object)this))) {
                    return false;
                }
                if (this.isValid()) {
                    return true;
                }
                TCFNodeRegister reg_node = (TCFNodeRegister)this.node.model.getNode(reg_id);
                if (!this.findRegs(reg_node, data)) {
                    return false;
                }
            }
            this.set(null, null, data);
            return true;
        }
        ISymbols.TypeClass type_class = type_data.getTypeClass();
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        if (this.par_level <= 0 || type_class == ISymbols.TypeClass.array) {
            if (type_class == ISymbols.TypeClass.composite) {
                if (!this.findFields(type_data, data, false)) {
                    return false;
                }
            } else if (type_class == ISymbols.TypeClass.array) {
                int size;
                int offs = this.par_level > 0 ? this.par_offs : 0;
                int n = size = this.par_level > 0 ? this.par_size : type_data.getLength();
                if (size <= 100) {
                    int i = offs;
                    while (i < offs + size) {
                        TCFNodeExpression n4 = this.findIndex(i, false);
                        if (n4 == null) {
                            n4 = new TCFNodeExpression(this.node, null, null, null, null, i, false);
                        }
                        n4.setSortPosition(i);
                        data.put(n4.id, n4);
                        ++i;
                    }
                } else {
                    int next_size = 100;
                    while (size / next_size > 100) {
                        next_size *= 100;
                    }
                    int i = offs;
                    while (i < offs + size) {
                        TCFNodeArrayPartition n5;
                        int sz = next_size;
                        if (i + sz > offs + size) {
                            sz = offs + size - i;
                        }
                        if ((n5 = this.findPartition(i, sz)) == null) {
                            n5 = new TCFNodeArrayPartition(this.node, this.par_level + 1, i, sz);
                        }
                        data.put(n5.id, n5);
                        i += next_size;
                    }
                }
            } else if (type_class == ISymbols.TypeClass.pointer) {
                TCFDataCache<ISymbols.Symbol> base_type_cache;
                TCFDataCache<IExpressions.Value> val_cache = ((TCFNodeExpression)exp).getValue();
                if (!val_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                IExpressions.Value val_data = (IExpressions.Value)val_cache.getData();
                if (val_data != null && (val_data.isImplicitPointer() || !this.isNull(val_data.getValue())) && (base_type_cache = this.node.model.getSymbolInfoCache(type_data.getBaseTypeID())) != null) {
                    if (!base_type_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    ISymbols.Symbol base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                    if (base_type_data != null && base_type_data.getTypeClass() != ISymbols.TypeClass.function && base_type_data.getSize() > 0) {
                        if (base_type_data.getTypeClass() == ISymbols.TypeClass.composite) {
                            if (!this.findFields(base_type_data, data, true)) {
                                return false;
                            }
                        } else {
                            TCFNodeExpression n = this.findIndex(0, true);
                            if (n == null) {
                                n = new TCFNodeExpression(this.node, null, null, null, null, 0, true);
                            }
                            n.setSortPosition(0);
                            data.put(n.id, n);
                        }
                    }
                }
            }
        }
        this.set(null, null, data);
        return true;
    }

    private boolean isNull(byte[] data) {
        if (data == null) {
            return true;
        }
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

