/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpStreamOp;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpOutStreamOp
extends OpStreamOp {
    private OutputStream output;
    private FSTreeNode node;

    public OpOutStreamOp(FSTreeNode node, OutputStream output) {
        this.node = node;
        this.output = output;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        super.run(monitor);
        InputStream input = null;
        try {
            try {
                int length;
                URL url = this.node.getLocationURL();
                InputStream in = url.openStream();
                input = new BufferedInputStream(in);
                byte[] data = new byte[5120];
                int chunk_size = (int)this.node.attr.size / 100;
                String total_size = this.formatSize(this.node.attr.size);
                int percentRead = 0;
                long bytesRead = 0L;
                while ((length = input.read(data)) >= 0 && !monitor.isCanceled()) {
                    int percent;
                    this.output.write(data, 0, length);
                    this.output.flush();
                    if (chunk_size == 0 || (percent = (int)(bytesRead += (long)length) / chunk_size) == percentRead) continue;
                    monitor.worked(percent - percentRead);
                    percentRead = percent;
                    monitor.subTask(NLS.bind((String)Messages.OpOutStreamOp_DownloadingProgress, (Object)this.formatSize(bytesRead), (Object)total_size));
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            monitor.done();
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
        monitor.done();
    }
}

