/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCommitAttr;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpDelete
extends Operation {
    private static final int RETRY_TIMES = 3;
    List<FSTreeNode> nodes;
    IConfirmCallback confirmCallback;

    public OpDelete(List<FSTreeNode> nodes, IConfirmCallback confirmCallback) {
        this.nodes = this.getAncestors(nodes);
        this.confirmCallback = confirmCallback;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            super.run(monitor);
            FSTreeNode head = this.nodes.get(0);
            IChannel channel = null;
            try {
                try {
                    channel = OpDelete.openChannel(head.peerNode.getPeer());
                    if (channel == null) break block8;
                    IFileSystem service = OpDelete.getBlockingFileSystem(channel);
                    if (service != null) {
                        for (FSTreeNode node : this.nodes) {
                            this.remove(node, service);
                        }
                        break block8;
                    }
                    String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)head.peerNode.getPeerId());
                    throw new TCFFileSystemException(4, message);
                }
                catch (TCFException e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            }
            finally {
                if (channel != null) {
                    Tcf.getChannelManager().closeChannel(channel);
                }
                monitor.done();
            }
        }
    }

    void remove(FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        if (node.isFile()) {
            this.removeFile(node, service);
        } else if (node.isDirectory()) {
            this.removeFolder(node, service);
        }
    }

    @Override
    protected void removeFolder(FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        List<FSTreeNode> children = this.getChildren(node, service);
        if (!children.isEmpty()) {
            for (FSTreeNode child : children) {
                this.remove(child, service);
            }
        }
        this.monitor.subTask(NLS.bind((String)Messages.OpDelete_RemovingFileFolder, (Object)node.name));
        super.removeFolder(node, service);
        this.monitor.worked(1);
    }

    @Override
    protected void removeFile(FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.monitor.subTask(NLS.bind((String)Messages.OpDelete_RemovingFileFolder, (Object)node.name));
        if (this.confirmCallback != null && this.confirmCallback.requires(node)) {
            IStatus status;
            if (!this.yes2All) {
                int result = this.confirmCallback.confirms(node);
                if (result == 1) {
                    this.yes2All = true;
                } else {
                    if (result == 2) {
                        this.monitor.worked(1);
                        return;
                    }
                    if (result == 3) {
                        this.monitor.setCanceled(true);
                        throw new InterruptedException();
                    }
                }
            }
            if (!(status = this.mkWritable(node)).isOK()) {
                return;
            }
        }
        super.removeFile(node, service);
        this.monitor.worked(1);
    }

    private IStatus mkWritable(FSTreeNode node) {
        FSTreeNode clone = (FSTreeNode)node.clone();
        if (node.isWindowsNode()) {
            clone.setReadOnly(false);
        } else {
            clone.setWritable(true);
        }
        OpCommitAttr op = new OpCommitAttr(node, clone.attr);
        NullOpExecutor executor = new NullOpExecutor();
        IStatus status = null;
        int i = 0;
        while (i < 3) {
            status = executor.execute(op);
            if (status.isOK()) {
                return status;
            }
            ++i;
        }
        return status;
    }

    @Override
    public String getName() {
        return Messages.OpDelete_Deleting;
    }

    @Override
    public int getTotalWork() {
        if (this.nodes != null && !this.nodes.isEmpty()) {
            final AtomicReference ref = new AtomicReference();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    block5: {
                        FSTreeNode head = OpDelete.this.nodes.get(0);
                        IChannel channel = null;
                        try {
                            channel = OpDelete.openChannel(head.peerNode.getPeer());
                            if (channel == null) break block5;
                            IFileSystem service = OpDelete.getBlockingFileSystem(channel);
                            if (service != null) {
                                ref.set(OpDelete.this.count(service, OpDelete.this.nodes));
                                break block5;
                            }
                            String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)head.peerNode.getPeerId());
                            throw new TCFFileSystemException(4, message);
                        }
                        finally {
                            if (channel != null) {
                                Tcf.getChannelManager().closeChannel(channel);
                            }
                        }
                    }
                }
            });
            Integer value = (Integer)ref.get();
            return value == null ? -1 : value;
        }
        return -1;
    }
}

