/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class OpCacheFileDigest
implements IOperation {
    FSTreeNode node;
    byte[] digest;

    public OpCacheFileDigest(FSTreeNode node) {
        this.node = node;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        File file = CacheManager.getCacheFile(this.node);
        BufferedInputStream input = null;
        try {
            try {
                int length;
                long totalSize = file.length();
                int chunk_size = (int)totalSize / 100;
                int percentRead = 0;
                long bytesRead = 0L;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                input = new BufferedInputStream(new DigestInputStream(new FileInputStream(file), digest));
                byte[] data = new byte[5120];
                while ((length = input.read(data)) >= 0) {
                    int percent;
                    if (chunk_size == 0 || (percent = (int)(bytesRead += (long)length) / chunk_size) == percentRead) continue;
                    monitor.worked(percent - percentRead);
                    percentRead = percent;
                }
                this.digest = digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public byte[] getDigest() {
        return this.digest;
    }

    @Override
    public String getName() {
        return "Update cache digest";
    }

    @Override
    public int getTotalWork() {
        return 100;
    }
}

