/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.IOpExecutor;

public class NullOpExecutor
implements IOpExecutor {
    ICallback callback;

    public NullOpExecutor() {
        this(null);
    }

    public NullOpExecutor(ICallback callback) {
        this.callback = callback;
    }

    @Override
    public IStatus execute(IOperation operation) {
        IStatus status;
        block10: {
            NullProgressMonitor monitor = new NullProgressMonitor();
            try {
                monitor.setTaskName(operation.getName());
                monitor.beginTask(operation.getName(), operation.getTotalWork());
                operation.run((IProgressMonitor)monitor);
                status = Status.OK_STATUS;
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getTargetException();
                if (throwable instanceof TCFException) {
                    int severity = ((TCFException)throwable).getSeverity();
                    status = new Status(severity, CorePlugin.getUniqueIdentifier(), throwable.getMessage(), throwable);
                } else {
                    status = new Status(4, CorePlugin.getUniqueIdentifier(), throwable.getMessage(), throwable);
                }
                monitor.done();
                break block10;
            }
            catch (InterruptedException interruptedException) {
                try {
                    status = Status.CANCEL_STATUS;
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        if (this.callback != null) {
            this.callback.done((Object)operation, status);
        }
        return status;
    }
}

