/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.CallbackBase;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.QueryDoneOpen;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.QueryDoneRoots;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class QueryDoneOpenChannel
extends CallbackBase
implements IChannelManager.DoneOpenChannel {
    FSTreeNode parentNode;
    ICallback callback;

    public QueryDoneOpenChannel(FSTreeNode parentNode) {
        this(parentNode, null);
    }

    public QueryDoneOpenChannel(FSTreeNode parentNode, ICallback callback) {
        this.parentNode = parentNode;
        this.callback = callback;
    }

    public void doneOpenChannel(Throwable error, final IChannel channel) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (error == null) {
            Callback proxy = new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    QueryDoneOpenChannel.this.parentNode.queryDone();
                    Tcf.getChannelManager().closeChannel(channel);
                    if (QueryDoneOpenChannel.this.callback != null) {
                        QueryDoneOpenChannel.this.callback.done(caller, status);
                    }
                }
            };
            IFileSystem service = (IFileSystem)channel.getRemoteService(IFileSystem.class);
            if (service != null) {
                if (this.parentNode.isSystemRoot()) {
                    service.roots((IFileSystem.DoneRoots)new QueryDoneRoots((ICallback)proxy, this.parentNode));
                } else {
                    String absPath = this.parentNode.getLocation();
                    service.opendir(absPath, (IFileSystem.DoneOpen)new QueryDoneOpen((ICallback)proxy, channel, service, this.parentNode));
                }
            } else {
                Status status = new Status(4, CorePlugin.getUniqueIdentifier(), Messages.Operation_NoFileSystemError, null);
                proxy.done((Object)this, (IStatus)status);
            }
        } else if (!(error instanceof OperationCanceledException) && this.callback != null) {
            Status status = new Status(4, CorePlugin.getUniqueIdentifier(), this.getErrorMessage(error), error);
            this.callback.done((Object)this, (IStatus)status);
        }
    }
}

