/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.Properties;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractIndexerPage
extends AbstractCOptionPage {
    protected static final String INDEX_ALL_FILES = DialogsMessages.AbstractIndexerPage_indexAllFiles;
    protected static final String TRUE = String.valueOf(true);
    private Button fAllSources;
    private Button fAllHeadersDefault;
    private Button fAllHeadersAlt;
    private Button fIndexOnOpen;
    private Button fIncludeHeuristics;
    private IntegerFieldEditor fFileSizeLimit;
    private Button fSkipReferences;
    private Button fSkipImplicitReferences;
    private Button fSkipMacroAndTypeReferences;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                AbstractIndexerPage.this.updateValidState();
            }
        }
    };
    protected PixelConverter pixelConverter;

    protected AbstractIndexerPage() {
    }

    public final IProject getCurrentProject() {
        ICOptionContainer container = this.getContainer();
        if (container != null) {
            return container.getProject();
        }
        return null;
    }

    @Override
    public void createControl(Composite parent) {
        this.pixelConverter = new PixelConverter((Control)parent);
        Composite page = new Composite(parent, 0);
        page.setFont(parent.getFont());
        GridLayout gl = new GridLayout(1, true);
        page.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        page.setLayoutData((Object)new GridData(768));
        Composite group = new Composite(page, 0);
        this.fAllSources = this.createAllFilesButton(group);
        IProject prj = this.getCurrentProject();
        if (prj == null || !CProject.hasCCNature((IProject)prj)) {
            this.fAllHeadersDefault = this.createAllHeadersButton(group);
        } else {
            this.fAllHeadersDefault = this.createAllCppHeadersButton(group);
            this.fAllHeadersAlt = this.createAllCHeadersButton(group);
        }
        this.fIndexOnOpen = this.createIndexOnOpenButton(group);
        this.fIncludeHeuristics = this.createIncludeHeuristicsButton(group);
        this.fFileSizeLimit = this.createFileSizeLimit(group);
        gl = new GridLayout(3, false);
        group.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        group.setLayoutData((Object)new GridData());
        group = new Composite(page, 0);
        gl = new GridLayout(1, false);
        group.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        group.setLayoutData((Object)new GridData());
        this.fSkipReferences = this.createSkipReferencesButton(group);
        this.fSkipImplicitReferences = this.createSkipImplicitReferencesButton(group);
        this.fSkipMacroAndTypeReferences = this.createSkipMacroAndTypeReferencesButton(group);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIndexerPage.this.updateEnablement();
            }
        };
        this.fSkipReferences.addSelectionListener((SelectionListener)selectionListener);
        this.fAllSources.addSelectionListener((SelectionListener)selectionListener);
        this.setControl((Control)page);
    }

    public void setProperties(Properties properties) {
        boolean indexAllFiles;
        if (this.fAllSources != null) {
            indexAllFiles = TRUE.equals(properties.get("indexAllFiles"));
            this.fAllSources.setSelection(indexAllFiles);
        }
        if (this.fAllHeadersDefault != null) {
            indexAllFiles = TRUE.equals(properties.get("indexUnusedHeadersWithDefaultLang"));
            this.fAllHeadersDefault.setSelection(indexAllFiles);
        }
        if (this.fAllHeadersAlt != null) {
            indexAllFiles = TRUE.equals(properties.get("indexUnusedHeadersWithAlternateLang"));
            this.fAllHeadersAlt.setSelection(indexAllFiles);
        }
        if (this.fIndexOnOpen != null) {
            boolean indexOnOpen = TRUE.equals(properties.get("indexOnOpen"));
            this.fIndexOnOpen.setSelection(indexOnOpen);
        }
        if (this.fIncludeHeuristics != null) {
            Object prop = properties.get("useHeuristicIncludeResolution");
            boolean use = prop == null || TRUE.equals(prop);
            this.fIncludeHeuristics.setSelection(use);
        }
        if (this.fFileSizeLimit != null) {
            Object prop = properties.get("skipFilesLargerThanMB");
            int size = 0;
            if (prop != null) {
                try {
                    size = Integer.parseInt(prop.toString());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (size <= 0) {
                size = 8;
            }
            this.fFileSizeLimit.setStringValue(String.valueOf(size));
        }
        if (this.fSkipReferences != null) {
            boolean skipReferences = TRUE.equals(properties.get("skipReferences"));
            this.fSkipReferences.setSelection(skipReferences);
        }
        if (this.fSkipImplicitReferences != null) {
            boolean skipImplicitReferences = TRUE.equals(properties.get("skipImplicitReferences"));
            this.fSkipImplicitReferences.setSelection(skipImplicitReferences);
        }
        if (this.fSkipMacroAndTypeReferences != null) {
            boolean skipTypeReferences = TRUE.equals(properties.get("skipTypeReferences"));
            boolean skipMacroReferences = TRUE.equals(properties.get("skipMacroReferences"));
            this.fSkipMacroAndTypeReferences.setSelection(skipTypeReferences && skipMacroReferences);
        }
        this.updateEnablement();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fAllSources != null) {
            props.put("indexAllFiles", String.valueOf(this.fAllSources.getSelection()));
        }
        if (this.fAllHeadersDefault != null) {
            props.put("indexUnusedHeadersWithDefaultLang", String.valueOf(this.fAllHeadersDefault.getSelection()));
        }
        if (this.fAllHeadersAlt != null) {
            props.put("indexUnusedHeadersWithAlternateLang", String.valueOf(this.fAllHeadersAlt.getSelection()));
        }
        if (this.fIndexOnOpen != null) {
            props.put("indexOnOpen", String.valueOf(this.fIndexOnOpen.getSelection()));
        }
        if (this.fIncludeHeuristics != null) {
            props.put("useHeuristicIncludeResolution", String.valueOf(this.fIncludeHeuristics.getSelection()));
        }
        if (this.fFileSizeLimit != null) {
            props.put("skipFilesLargerThanMB", String.valueOf(this.fFileSizeLimit.getIntValue()));
        }
        if (this.fSkipReferences != null) {
            props.put("skipReferences", String.valueOf(this.fSkipReferences.getSelection()));
        }
        if (this.fSkipImplicitReferences != null) {
            props.put("skipImplicitReferences", String.valueOf(this.fSkipImplicitReferences.getSelection()));
        }
        if (this.fSkipMacroAndTypeReferences != null) {
            String value = String.valueOf(this.fSkipMacroAndTypeReferences.getSelection());
            props.put("skipTypeReferences", value);
            props.put("skipMacroReferences", value);
        }
        return props;
    }

    @Override
    public final void performApply(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void performDefaults() {
        throw new UnsupportedOperationException();
    }

    public void updateEnablement() {
        if (this.fSkipReferences != null) {
            boolean skipReferences = this.fSkipReferences.getSelection();
            if (this.fSkipImplicitReferences != null) {
                this.fSkipImplicitReferences.setEnabled(!skipReferences);
            }
            if (this.fSkipMacroAndTypeReferences != null) {
                this.fSkipMacroAndTypeReferences.setEnabled(!skipReferences);
            }
        }
    }

    private void updateValidState() {
        if (!this.fFileSizeLimit.isValid()) {
            this.setErrorMessage(this.fFileSizeLimit.getErrorMessage());
            this.setValid(false);
        } else {
            this.setValid(true);
        }
        ICOptionContainer container = this.getContainer();
        if (container != null) {
            container.updateContainer();
        }
    }

    private Button createAllFilesButton(Composite page) {
        Button result = ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllFiles);
        ((GridData)result.getLayoutData()).horizontalSpan = 3;
        return result;
    }

    private Button createAllHeadersButton(Composite page) {
        Button result = ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllHeaders);
        ((GridData)result.getLayoutData()).horizontalSpan = 3;
        return result;
    }

    private Button createAllCHeadersButton(Composite page) {
        Button result = ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllHeadersC);
        ((GridData)result.getLayoutData()).horizontalSpan = 3;
        return result;
    }

    private Button createAllCppHeadersButton(Composite page) {
        Button result = ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllHeadersCpp);
        ((GridData)result.getLayoutData()).horizontalSpan = 3;
        return result;
    }

    private Button createIndexOnOpenButton(Composite page) {
        Button result = ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexOpenedFiles);
        ((GridData)result.getLayoutData()).horizontalSpan = 3;
        return result;
    }

    private Button createIncludeHeuristicsButton(Composite page) {
        Button result = ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_heuristicIncludes);
        ((GridData)result.getLayoutData()).horizontalSpan = 3;
        return result;
    }

    private IntegerFieldEditor createFileSizeLimit(Composite group) {
        IntegerFieldEditor result = new IntegerFieldEditor("skipFilesLargerThanMB", DialogsMessages.AbstractIndexerPage_fileSizeLimit, group, 5);
        result.setValidRange(1, 100000);
        ControlFactory.createLabel(group, DialogsMessages.CacheSizeBlock_MB);
        Text control = result.getTextControl(group);
        LayoutUtil.setWidthHint((Control)control, this.pixelConverter.convertWidthInCharsToPixels(10));
        LayoutUtil.setHorizontalGrabbing((Control)control, false);
        result.setPropertyChangeListener(this.validityChangeListener);
        return result;
    }

    private Button createSkipReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipAllReferences);
    }

    private Button createSkipImplicitReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipImplicitReferences);
    }

    private Button createSkipMacroAndTypeReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipTypeAndMacroReferences);
    }

    @Deprecated
    protected void setSupportForFilesParsedUpFront(boolean enable) {
    }
}

