/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.utils.NamespaceHelper;
import org.eclipse.core.runtime.CoreException;

public class NameHelper {
    private static final Pattern localVariableRegexp = Pattern.compile("[a-z_A-Z]\\w*");

    public static boolean isValidLocalVariableName(String name) {
        return localVariableRegexp.matcher(name).matches();
    }

    public static boolean isKeyword(String name) {
        CharArrayIntMap keywords = new CharArrayIntMap(0, -1);
        Keywords.addKeywordsC((CharArrayIntMap)keywords);
        Keywords.addKeywordsCpp((CharArrayIntMap)keywords);
        Keywords.addKeywordsPreprocessor((CharArrayIntMap)keywords);
        return keywords.containsKey(name.toCharArray());
    }

    public static ICPPASTQualifiedName createQualifiedNameFor(IASTName declaratorName, ITranslationUnit declarationTu, int selectionOffset, ITranslationUnit insertFileTu, int insertLocation, CRefactoringContext astCache) throws CoreException {
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        IASTName[] declarationNames = NamespaceHelper.getSurroundingNamespace(declarationTu, selectionOffset, astCache).getNames();
        IASTName[] implementationNames = NamespaceHelper.getSurroundingNamespace(insertFileTu, insertLocation, astCache).getNames();
        int i = 0;
        while (i < declarationNames.length) {
            if (i >= implementationNames.length) {
                qname.addName(declarationNames[i]);
            } else if (!Arrays.equals(declarationNames[i].toCharArray(), implementationNames[i].toCharArray())) {
                qname.addName(declarationNames[i]);
            }
            ++i;
        }
        qname.addName(declaratorName.copy(IASTNode.CopyStyle.withLocations));
        return qname;
    }

    public static String getTypeName(IASTParameterDeclaration parameter) {
        IType type;
        IASTName name = parameter.getDeclarator().getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariable && (type = ((IVariable)binding).getType()) != null) {
            return ASTTypeUtil.getType((IType)type);
        }
        return "";
    }
}

