/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.ui.refactoring.Container;

public class InsertionPointFinder {
    private static ArrayList<ICPPASTFunctionDeclarator> allafterdeclarations;
    private static ArrayList<ICPPASTFunctionDefinition> alldefinitionsoutside;
    private static IASTDeclaration position;

    public static IASTDeclaration findInsertionPoint(IASTTranslationUnit classunit, IASTTranslationUnit functiondefunit, IASTFunctionDeclarator funcDecl) {
        position = null;
        InsertionPointFinder.findAllDeclarationsAfterInClass(classunit, funcDecl);
        InsertionPointFinder.findAllDefinitionsoutSideClass(functiondefunit);
        InsertionPointFinder.findRightPlace();
        return position;
    }

    private static void findRightPlace() {
        if (allafterdeclarations == null || alldefinitionsoutside == null) {
            return;
        }
        for (ICPPASTFunctionDeclarator decl : allafterdeclarations) {
            String decl_name = decl.getName().toString();
            for (ICPPASTFunctionDefinition def : alldefinitionsoutside) {
                String def_name = null;
                if (def.getDeclarator().getName() instanceof ICPPASTQualifiedName) {
                    ICPPASTQualifiedName qname = (ICPPASTQualifiedName)def.getDeclarator().getName();
                    def_name = qname.getNames()[1].toString();
                } else if (def.getDeclarator().getName() instanceof CPPASTName) {
                    def_name = def.getDeclarator().getName().toString();
                }
                if (!decl_name.equals(def_name)) continue;
                position = def.getParent() != null && def.getParent() instanceof ICPPASTTemplateDeclaration ? (IASTDeclaration)def.getParent() : def;
                return;
            }
        }
    }

    private static void findAllDeclarationsAfterInClass(IASTTranslationUnit classunit, IASTFunctionDeclarator funcDecl) {
        ICPPASTCompositeTypeSpecifier klass = InsertionPointFinder.getklass(classunit);
        if (klass != null) {
            allafterdeclarations = InsertionPointFinder.getDeclarationsInClass(klass, funcDecl);
        }
    }

    private static void findAllDefinitionsoutSideClass(IASTTranslationUnit ast) {
        final ArrayList definitions = new ArrayList();
        if (ast == null) {
            alldefinitionsoutside = definitions;
            return;
        }
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof ICPPASTFunctionDefinition) {
                    if (declaration.getParent() != null && CPPVisitor.findAncestorWithType((IASTNode)declaration, CPPASTCompositeTypeSpecifier.class) != null) {
                        return 3;
                    }
                    definitions.add((ICPPASTFunctionDefinition)declaration);
                }
                return super.visit(declaration);
            }
        });
        alldefinitionsoutside = definitions;
    }

    private static ArrayList<ICPPASTFunctionDeclarator> getDeclarationsInClass(ICPPASTCompositeTypeSpecifier klass, final IASTFunctionDeclarator selected) {
        final ArrayList<ICPPASTFunctionDeclarator> declarations = new ArrayList<ICPPASTFunctionDeclarator>();
        klass.accept(new ASTVisitor(){
            boolean got;
            {
                this.shouldVisitDeclarators = true;
                this.got = false;
            }

            public int visit(IASTDeclarator declarator) {
                if (declarator instanceof ICPPASTFunctionDeclarator) {
                    if ((ICPPASTFunctionDeclarator)declarator == selected) {
                        this.got = true;
                    }
                    if (this.got) {
                        declarations.add((ICPPASTFunctionDeclarator)declarator);
                    }
                }
                return super.visit(declarator);
            }
        });
        return declarations;
    }

    private static ICPPASTCompositeTypeSpecifier getklass(IASTTranslationUnit unit) {
        final Container result = new Container();
        unit.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclSpecifiers = true;
            }

            public int visit(IASTDeclSpecifier declSpec) {
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                    result.setObject((ICPPASTCompositeTypeSpecifier)declSpec);
                    return 2;
                }
                return super.visit(declSpec);
            }
        });
        return (ICPPASTCompositeTypeSpecifier)result.getObject();
    }
}

