/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards.newWizard;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.wizards.interfaces.INewTargetWizard;
import org.eclipse.tcf.te.ui.wizards.newWizard.NewWizardSelectionPage;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.wizards.IWizardDescriptor;

class NewWizardNode
implements IWizardNode,
IPluginContribution {
    private final IWizardDescriptor descriptor;
    private final NewWizardSelectionPage page;
    private IWizard wizard;

    public NewWizardNode(NewWizardSelectionPage page, IWizardDescriptor descriptor) {
        Assert.isNotNull((Object)((Object)page));
        Assert.isNotNull((Object)descriptor);
        this.page = page;
        this.descriptor = descriptor;
    }

    public void dispose() {
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public String getLocalId() {
        IPluginContribution contribution = (IPluginContribution)Util.getAdapter((Object)this.descriptor, IPluginContribution.class);
        if (contribution != null) {
            return contribution.getLocalId();
        }
        return this.descriptor.getId();
    }

    public String getPluginId() {
        IPluginContribution contribution = (IPluginContribution)Util.getAdapter((Object)this.descriptor, IPluginContribution.class);
        if (contribution != null) {
            return contribution.getPluginId();
        }
        return null;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }

    public IWizard getWizard() {
        if (this.wizard == null) {
            this.wizard = this.createWizard(this.descriptor);
        }
        return this.wizard;
    }

    private final IWorkbenchWizard createWizard(IWizardDescriptor descriptor) {
        Assert.isNotNull((Object)descriptor);
        IWorkbenchWizard wizard = null;
        try {
            wizard = descriptor.createWizard();
            if (wizard instanceof INewTargetWizard) {
                ((INewTargetWizard)wizard).setWizardDescriptor(descriptor);
            }
            IStructuredSelection wizardSelection = descriptor.adaptedSelection(this.page.getSelection());
            wizard.init(this.page.getWorkbench(), wizardSelection);
        }
        catch (CoreException e) {
            this.page.setErrorMessage(Messages.NewWizardSelectionPage_createWizardFailed);
            Status status = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.NewWizardSelectionPage_createWizardFailed, (Throwable)e);
            UIPlugin.getDefault().getLog().log((IStatus)status);
        }
        return wizard;
    }
}

