/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tcf.te.ui.trees.AbstractTreeControl;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;

public class TreeViewerHeaderMenu
extends Menu
implements SelectionListener,
Listener,
DisposeListener {
    private Menu treeMenu;
    private AbstractTreeControl treeControl;

    public TreeViewerHeaderMenu(AbstractTreeControl treeControl) {
        super(treeControl.getViewer().getControl());
        this.treeControl = treeControl;
        Tree tree = (Tree)treeControl.getViewer().getControl();
        tree.addListener(35, (Listener)this);
        tree.addDisposeListener((DisposeListener)this);
        this.treeMenu = tree.getMenu();
    }

    public void create() {
        ColumnDescriptor[] columns = this.treeControl.getViewerColumns();
        Assert.isNotNull((Object)columns);
        int i = 0;
        while (i < columns.length) {
            ColumnDescriptor column = columns[i];
            MenuItem menuItem = new MenuItem((Menu)this, 32);
            menuItem.setText(column.getName());
            menuItem.setSelection(column.isVisible());
            menuItem.addSelectionListener((SelectionListener)this);
            menuItem.setData((Object)column);
            menuItem.setEnabled(i != 0);
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        boolean visible;
        MenuItem item = (MenuItem)e.getSource();
        ColumnDescriptor column = (ColumnDescriptor)item.getData();
        if (this.treeControl.setColumnVisible(column, visible = item.getSelection())) {
            this.treeControl.columnMoved();
            this.treeControl.getViewer().refresh();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        Tree t = (Tree)event.widget;
        Point pt = t.getDisplay().map(null, (Control)t, event.x, event.y);
        Rectangle clientArea = t.getClientArea();
        boolean isHeader = pt.y - clientArea.y <= t.getHeaderHeight();
        t.setMenu((Menu)(isHeader ? this : this.treeMenu));
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.treeMenu != null && !this.treeMenu.isDisposed()) {
            this.treeMenu.dispose();
        }
        if (!this.isDisposed()) {
            this.dispose();
        }
    }

    protected void checkSubclass() {
    }

    public void updateSelection() {
        ColumnDescriptor[] columns = this.treeControl.getViewerColumns();
        Assert.isNotNull((Object)columns);
        int i = 0;
        while (i < columns.length) {
            MenuItem item = this.getItem(i);
            ColumnDescriptor column = columns[i];
            item.setSelection(column.isVisible());
            ++i;
        }
    }
}

