/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.launchcontext;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.launch.core.bindings.LaunchConfigTypeBindingsManager;
import org.eclipse.tcf.te.launch.core.selection.RemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.launch.ui.tabs.launchcontext.AbstractContextSelectorControl;
import org.eclipse.tcf.te.launch.ui.tabs.launchcontext.AbstractContextSelectorTab;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.tcf.launch.ui.launchcontext.ContextSelectorSection;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.ui.forms.IManagedForm;

public abstract class AbstractLaunchContextMainTab
extends AbstractContextSelectorTab {
    ILaunchConfiguration configuration = null;

    public void initializeFrom(ILaunchConfiguration configuration) {
        AbstractContextSelectorControl control;
        super.initializeFrom(configuration);
        this.configuration = configuration;
        if (this.getContextSelectorSection() != null && (control = (AbstractContextSelectorControl)this.getContextSelectorSection().getAdapter(AbstractContextSelectorControl.class)) != null && control.getViewer() != null) {
            control.getViewer().refresh();
        }
    }

    protected ContextSelectorSection doCreateContextSelectorSection(IManagedForm form, Composite panel) {
        return new ContextSelectorSection(form, panel){

            @Override
            protected AbstractContextSelectorControl doCreateContextSelector() {
                MainTabContextSelectorControl control = new MainTabContextSelectorControl(this, null);
                AbstractLaunchContextMainTab.this.doConfigureContextSelectorControl(control);
                return control;
            }
        };
    }

    protected void doConfigureContextSelectorControl(AbstractContextSelectorControl control) {
    }

    protected class MainTabContextSelectorControl
    extends ContextSelectorSection.ContextSelectorSectionSelectorControl {
        public MainTabContextSelectorControl(ContextSelectorSection section, IDialogPage parentPage) {
            super(section, parentPage);
        }

        protected ViewerFilter[] doCreateViewerFilters() {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(Arrays.asList(super.doCreateViewerFilters()));
            filters.add(new MainTabContextSelectorViewerFilter());
            return filters.toArray(new ViewerFilter[filters.size()]);
        }
    }

    protected class MainTabContextSelectorViewerFilter
    extends ViewerFilter {
        protected MainTabContextSelectorViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IPeerModel) {
                String typeId = null;
                if (AbstractLaunchContextMainTab.this.configuration != null) {
                    try {
                        typeId = AbstractLaunchContextMainTab.this.configuration.getType().getIdentifier();
                    }
                    catch (CoreException coreException) {}
                }
                String mode = AbstractLaunchContextMainTab.this.getLaunchConfigurationDialog().getMode();
                if (typeId != null && mode != null) {
                    return LaunchConfigTypeBindingsManager.getInstance().isValidLaunchConfigType(typeId, mode, (ISelectionContext)new RemoteSelectionContext((IModelNode)((IPeerModel)element), true));
                }
            }
            return true;
        }
    }
}

