/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.TestErrorsDialog;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.launch.ui.editor.AbstractTcfLaunchTabContainerEditorPage;
import org.eclipse.tcf.te.tcf.launch.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractDiagnosticsCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object element : (IStructuredSelection)selection) {
                String remoteServices;
                if (!(element instanceof IPeerModel)) continue;
                IPeerModel node = (IPeerModel)element;
                ILocatorModelPeerNodeQueryService service = (ILocatorModelPeerNodeQueryService)node.getModel().getService(ILocatorModelPeerNodeQueryService.class);
                String string = remoteServices = service != null ? service.queryRemoteServices(node) : null;
                if (remoteServices == null || !remoteServices.contains("Diagnostics")) continue;
                this.runDiagnostics(node, shell);
            }
        }
        return null;
    }

    protected abstract boolean runAsLoop();

    void runDiagnostics(IPeerModel node, Shell parentShell) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)parentShell);
        Shell shell = new Shell(parentShell, 32800);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        shell.setLayout((Layout)layout);
        shell.setText(Messages.AbstractDiagnosticsCommandHandler_progress_title);
        CLabel label = new CLabel((Composite)shell, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, false));
        label.setText(Messages.AbstractDiagnosticsCommandHandler_progress_title);
        final TCFTestSuite[] test = new TCFTestSuite[1];
        Button button_cancel = new Button((Composite)shell, 8);
        button_cancel.setText(Messages.AbstractDiagnosticsCommandHandler_progress_button_cancel);
        button_cancel.setLayoutData((Object)new GridData(3, 2, false, false));
        button_cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (test[0] != null) {
                            test[0].cancel();
                        }
                    }
                });
            }
        });
        SWTFactory.createVerticalSpacer((Composite)shell, (int)0);
        ProgressBar bar = new ProgressBar((Composite)shell, 256);
        bar.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        shell.setDefaultButton(button_cancel);
        shell.pack();
        shell.setSize(483, shell.getSize().y);
        Rectangle rc0 = parentShell.getBounds();
        Rectangle rc1 = shell.getBounds();
        shell.setLocation(rc0.x + (rc0.width - rc1.width) / 2, rc0.y + (rc0.height - rc1.height) / 2);
        shell.setVisible(true);
        ILaunchConfigurationWorkingCopy wc = AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(node);
        this.runDiagnostics(node.getPeer(), this.runAsLoop(), test, shell, label, bar, wc);
    }

    void runDiagnostics(final IPeer peer, final boolean loop, final TCFTestSuite[] test, final Shell shell, final CLabel label, final ProgressBar bar, final ILaunchConfigurationWorkingCopy wc) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)test);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)label);
        Assert.isNotNull((Object)bar);
        final Display display = shell != null ? shell.getDisplay() : PlatformUI.getWorkbench().getDisplay();
        final TCFTestSuite.TestListener done = new TCFTestSuite.TestListener(){
            String last_text = "";
            int last_count = 0;
            int last_total = 0;

            public void progress(String label_text, int count_done, int count_total) {
                if (!$assertionsDisabled && test[0] == null) {
                    throw new AssertionError();
                }
                if ((label_text == null || this.last_text.equals(label_text)) && this.last_total == count_total && (float)(count_done - this.last_count) / (float)count_total < 0.02f) {
                    return;
                }
                if (label_text != null) {
                    this.last_text = label_text;
                }
                this.last_total = count_total;
                this.last_count = count_done;
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        label.setText(last_text);
                        bar.setMinimum(0);
                        bar.setMaximum(last_total);
                        bar.setSelection(last_count);
                    }
                });
            }

            public void done(final Collection<Throwable> errors) {
                if (!$assertionsDisabled && test[0] == null) {
                    throw new AssertionError();
                }
                final boolean b = test[0].isCanceled();
                test[0] = null;
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (errors.size() > 0) {
                            shell.dispose();
                            new TestErrorsDialog(shell, ImageCache.getImage((String)"icons/tcf.gif"), errors).open();
                        } else if (loop && !b) {
                            AbstractDiagnosticsCommandHandler.this.runDiagnostics(peer, true, test, shell, label, bar, wc);
                        } else {
                            shell.dispose();
                        }
                    }
                });
            }
        };
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    boolean enable_tracing;
                    ArrayList<TCFLaunchDelegate.PathMapRule> path_map = new ArrayList<TCFLaunchDelegate.PathMapRule>();
                    String path_map_cfg = wc.getAttribute("org.eclipse.tcf.debug.PathMap", "");
                    ArrayList map = TCFLaunchDelegate.parsePathMapAttribute((String)path_map_cfg);
                    for (TCFLaunchDelegate.PathMapRule r : map) {
                        path_map.add(r);
                    }
                    if (path_map.isEmpty()) {
                        path_map = null;
                    }
                    HashMap mem_map = null;
                    String mem_map_cfg = wc.getAttribute("org.eclipse.tcf.debug.MemoryMap", null);
                    if (mem_map_cfg != null) {
                        mem_map = new HashMap();
                        TCFLaunchDelegate.parseMemMapsAttribute(mem_map, (String)mem_map_cfg);
                    }
                    boolean bl = enable_tracing = "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf.debug/debug")) && "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf.debug/debug/tests/runcontrol"));
                    if (enable_tracing) {
                        System.setProperty("org.eclipse.tcf.debug.tracing.tests.runcontrol", "true");
                    }
                    test[0] = new TCFTestSuite(peer, done, path_map, mem_map);
                }
                catch (Throwable x) {
                    ArrayList<Throwable> errors = new ArrayList<Throwable>();
                    errors.add(x);
                    done.done(errors);
                }
            }
        });
    }
}

