/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui.views;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.terminals.ui.views.RSETerminalConnectionThread;
import org.eclipse.rse.services.terminals.ITerminalShell;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class RSETerminalConnectorImpl
extends TerminalConnectorImpl {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    IHost host;
    private RSETerminalConnectionThread fConnection;
    private ITerminalShell shell;

    public RSETerminalConnectorImpl(IHost host) {
        this.host = host;
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fConnection = new RSETerminalConnectionThread(this, control);
        this.fConnection.start();
    }

    public void doDisconnect() {
        this.fConnection.disconnect();
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                RSECorePlugin.getDefault().getLogger().logError("Error while closing input stream", (Throwable)exception);
            }
        }
        if (this.getTerminalToRemoteStream() != null) {
            try {
                this.getTerminalToRemoteStream().close();
            }
            catch (Exception exception) {
                RSECorePlugin.getDefault().getLogger().logError("Error while closing terminal-to-remote stream", (Throwable)exception);
            }
        }
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    public String getSettingsSummary() {
        return "RSE: " + this.host.getName();
    }

    public boolean isLocalEcho() {
        return this.shell.isLocalEcho();
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.shell != null) {
            this.shell.setTerminalSize(newWidth, newHeight);
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    public void setTerminalHostShell(ITerminalShell shell) {
        this.shell = shell;
    }

    public ITerminalShell getTerminalHostShell() {
        return this.shell;
    }
}

