/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.services;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelUpdateService;
import org.eclipse.tcf.te.tcf.core.model.services.AbstractModelService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;

public class RuntimeModelUpdateService
extends AbstractModelService<IRuntimeModel>
implements IModelUpdateService {
    public RuntimeModelUpdateService(IRuntimeModel model) {
        super((IModel)model);
    }

    public void add(IModelNode node) {
        Assert.isNotNull((Object)node);
        ((IRuntimeModel)this.getModel()).add(node);
    }

    public void remove(IModelNode node) {
        Assert.isNotNull((Object)node);
        ((IRuntimeModel)this.getModel()).remove(node, false);
    }

    public void update(IModelNode dst, IModelNode src) {
        Assert.isNotNull((Object)dst);
        Assert.isNotNull((Object)src);
        boolean eventEnablementChanged = dst.setChangeEventsEnabled(false);
        boolean dstNodeChanged = false;
        for (String key : src.getProperties().keySet()) {
            dstNodeChanged |= dst.setProperty(key, src.getProperty(key));
        }
        IAsyncRefreshableCtx dstRefreshable = (IAsyncRefreshableCtx)dst.getAdapter(IAsyncRefreshableCtx.class);
        IAsyncRefreshableCtx srcRefreshable = (IAsyncRefreshableCtx)src.getAdapter(IAsyncRefreshableCtx.class);
        if (dstRefreshable != null && srcRefreshable != null) {
            dstRefreshable.setPendingOperationNode(srcRefreshable.getPendingOperationNode());
            dstRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, srcRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT));
            dstRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, srcRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST));
        }
        if (dst instanceof IProcessContextNode && src instanceof IProcessContextNode) {
            ((IProcessContextNode)dst).setSysMonitorContext(((IProcessContextNode)src).getSysMonitorContext());
            ((IProcessContextNode)dst).setProcessContext(((IProcessContextNode)src).getProcessContext());
            dst.setProperty("cmdline", src.getProperty("cmdline"));
        }
        if (eventEnablementChanged) {
            dst.setChangeEventsEnabled(true);
        }
        if (dstNodeChanged) {
            dst.fireChangeEvent("properties", null, (Object)dst.getProperties());
        }
    }
}

