/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.eclipse.tcf.core.StreamChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;

public class ChannelTCP
extends StreamChannel {
    private Socket socket;
    private int timeout;
    private InputStream inp;
    private OutputStream out;
    private boolean started;
    private boolean closed;
    private static SSLContext ssl_context;

    public static void setSSLContext(SSLContext ssl_context) {
        ChannelTCP.ssl_context = ssl_context;
    }

    public ChannelTCP(IPeer remote_peer, final String host, final int port, final boolean ssl) {
        super(remote_peer);
        this.socket = new Socket();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ChannelTCP.this.socket.connect(new InetSocketAddress(host, port), ChannelTCP.this.timeout);
                            ChannelTCP.this.socket.setTcpNoDelay(true);
                            ChannelTCP.this.socket.setKeepAlive(true);
                            if (ssl) {
                                if (ssl_context == null) {
                                    throw new Exception("SSL context is not set");
                                }
                                ChannelTCP.this.socket = ssl_context.getSocketFactory().createSocket(ChannelTCP.this.socket, host, port, true);
                                ((SSLSocket)ChannelTCP.this.socket).startHandshake();
                            }
                            ChannelTCP.this.inp = new BufferedInputStream(ChannelTCP.this.socket.getInputStream());
                            ChannelTCP.this.out = new BufferedOutputStream(ChannelTCP.this.socket.getOutputStream());
                            ChannelTCP.this.onSocketConnected(null);
                        }
                        catch (Exception x) {
                            ChannelTCP.this.onSocketConnected(x);
                        }
                    }
                };
                thread.setName("TCF Socket Connect");
                thread.start();
            }
        });
    }

    public ChannelTCP(IPeer remote_peer, String host, int port) {
        this(remote_peer, host, port, false);
    }

    public ChannelTCP(IPeer local_peer, IPeer remote_peer, Socket socket) throws IOException {
        super(local_peer, remote_peer);
        this.socket = socket;
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        this.inp = new BufferedInputStream(socket.getInputStream());
        this.out = new BufferedOutputStream(socket.getOutputStream());
        this.onSocketConnected(null);
    }

    public void setConnectTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    public void setPerformancePreferences(int connection_time, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connection_time, latency, bandwidth);
    }

    private void onSocketConnected(final Throwable x) {
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (x != null) {
                        ChannelTCP.this.terminate(x);
                        ChannelTCP.this.closed = true;
                    }
                    if (ChannelTCP.this.closed) {
                        try {
                            if (ChannelTCP.this.socket == null) break block7;
                            ChannelTCP.this.socket.close();
                            if (ChannelTCP.this.out != null) {
                                ChannelTCP.this.out.close();
                            }
                            if (ChannelTCP.this.inp != null) {
                                ChannelTCP.this.inp.close();
                            }
                        }
                        catch (IOException y) {
                            Protocol.log("Cannot close socket", y);
                        }
                    } else {
                        ChannelTCP.this.started = true;
                        ChannelTCP.this.start();
                    }
                }
            }
        });
    }

    @Override
    protected final int get() throws IOException {
        block4: {
            try {
                if (!this.closed) break block4;
                return -1;
            }
            catch (IOException x) {
                if (this.closed) {
                    return -1;
                }
                throw x;
            }
        }
        return this.inp.read();
    }

    @Override
    protected final int get(byte[] buf) throws IOException {
        block4: {
            try {
                if (!this.closed) break block4;
                return -1;
            }
            catch (IOException x) {
                if (this.closed) {
                    return -1;
                }
                throw x;
            }
        }
        return this.inp.read(buf);
    }

    @Override
    protected final void put(int b) throws IOException {
        assert (b >= 0 && b <= 255);
        if (this.closed) {
            return;
        }
        this.out.write(b);
    }

    @Override
    protected final void put(byte[] buf) throws IOException {
        if (this.closed) {
            return;
        }
        this.out.write(buf);
    }

    @Override
    protected final void flush() throws IOException {
        if (this.closed) {
            return;
        }
        this.out.flush();
    }

    @Override
    protected void stop() throws IOException {
        this.closed = true;
        if (this.started) {
            this.socket.close();
            this.out.close();
            this.inp.close();
        }
    }
}

