/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.tcf.te.ui.controls.nls.Messages;

public abstract class Validator
implements IMessageProvider,
ICellEditorValidator {
    private String message = null;
    private int messageType = 0;
    private Map<String, String> messages = new HashMap<String, String>();
    private Map<String, Integer> messageTypes = new HashMap<String, Integer>();
    public static final int NO_ATTR = 0;
    public static final int ATTR_MANDATORY = 1;
    private int attributes;

    public Validator(int attributes) {
        this.setAttributes(attributes);
    }

    public void setAttributes(int attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(int attribute) {
        if (!this.isAttribute(attribute)) {
            this.attributes |= attribute;
        }
    }

    public void delAttribute(int attribute) {
        if (this.isAttribute(attribute)) {
            this.attributes -= attribute;
        }
    }

    public int getAttributes() {
        return this.attributes;
    }

    public boolean isAttribute(int attribute) {
        return Validator.isAttribute(attribute, this.attributes);
    }

    public static boolean isAttribute(int attribute, int attributes) {
        return (attributes & attribute) == attribute;
    }

    protected void init() {
        this.setMessage(null);
        this.setMessageType(0);
    }

    public abstract boolean isValid(String var1);

    public final String isValid(Object newValue) {
        String strValue;
        String string = strValue = newValue != null ? newValue.toString() : null;
        if (!this.isValid(strValue)) {
            return this.getMessage();
        }
        return null;
    }

    protected final void setMessage(String message, int messageType) {
        this.setMessage(message);
        this.setMessageType(messageType);
    }

    protected final void setMessage(String message) {
        this.message = message;
    }

    public final String getMessage() {
        return this.message;
    }

    protected final void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public final int getMessageType() {
        return this.messageType;
    }

    protected final String getMessageText(String key) {
        String message = this.messages.get(key);
        if (message == null) {
            message = this.getString(key);
            this.setMessageText(key, message);
        }
        return message;
    }

    protected final int getMessageTextType(String key, int proposedType) {
        Integer type = this.messageTypes.get(key);
        if (type == null || type == -1) {
            type = proposedType;
        }
        return type;
    }

    public final void setMessageText(String key, String text) {
        this.setMessageText(key, text, -1);
    }

    public final void setMessageText(String key, String text, int type) {
        if (key != null) {
            if (text != null) {
                this.messages.put(key, text);
            } else {
                this.messages.put(key, this.getString(key));
            }
            if (type != -1) {
                this.messageTypes.put(key, type);
            } else {
                this.messageTypes.remove(key);
            }
        }
    }

    protected String getString(String key) {
        Assert.isNotNull((Object)key);
        return Messages.getString(key);
    }
}

