/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.profiler;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupParticipant;
import org.eclipse.tcf.internal.debug.model.TCFFunctionRef;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IProfiler;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ProfilerView
extends ViewPart {
    private static final long UPDATE_DELAY = 4000L;
    private final Map<TCFModel, Map<String, ProfileData>> data = new HashMap<TCFModel, Map<String, ProfileData>>();
    private final ISelectionListener selection_listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection s) {
            if (s instanceof IStructuredSelection) {
                final Object obj = ((IStructuredSelection)s).getFirstElement();
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (obj instanceof TCFNode) {
                            ProfilerView.this.selection = (TCFNode)obj;
                        } else {
                            ProfilerView.this.selection = null;
                        }
                        ProfilerView.this.updateView();
                    }
                });
            }
        }
    };
    private final TCFModelManager.ModelManagerListener launch_listener = new TCFModelManager.ModelManagerListener(){

        @Override
        public void onConnected(TCFLaunch launch, TCFModel model) {
        }

        @Override
        public void onDisconnected(TCFLaunch launch, TCFModel model) {
            ProfilerView.this.data.remove(model);
            ProfilerView.this.updateView();
        }
    };
    private final Runnable read_data = new Runnable(){
        final Set<IToken> cmds = new HashSet<IToken>();

        @Override
        public void run() {
            if (ProfilerView.this.disposed) {
                ProfilerView.this.data.clear();
                return;
            }
            for (Map.Entry e : ProfilerView.this.data.entrySet()) {
                TCFModel model = (TCFModel)e.getKey();
                IProfiler profiler = (IProfiler)model.getChannel().getRemoteService(IProfiler.class);
                if (profiler == null) continue;
                Map ctx_map = (Map)e.getValue();
                for (final ProfileData p : ctx_map.values()) {
                    if (p.stopped) continue;
                    this.cmds.add(profiler.read(p.ctx, new IProfiler.DoneRead(){

                        public void doneRead(IToken token, Exception error, Map<String, Object>[] data) {
                            cmds.remove(token);
                            if (cmds.size() == 0) {
                                Protocol.invokeLater((long)4000L, (Runnable)ProfilerView.this.read_data);
                                ProfilerView.this.updateView();
                            }
                            if (error != null) {
                                Activator.log(error);
                            } else if (!ProfilerView.this.disposed && data != null) {
                                boolean bl = p.unsupported = data.length == 0;
                                if (data.length > 0) {
                                    Map<String, Object>[] mapArray = data;
                                    int n = data.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Map<String, Object> m = mapArray[n2];
                                        ProfilerView.this.addSamples(p, m);
                                        ++n2;
                                    }
                                }
                            }
                        }
                    }));
                }
            }
            if (this.cmds.size() == 0) {
                Protocol.invokeLater((long)4000L, (Runnable)this);
                ProfilerView.this.updateView();
            }
        }
    };
    private final Action action_start = new Action("Start", ImageCache.getImageDescriptor("icons/full/obj16/thread_obj.gif")){

        public void run() {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ProfilerView.this.selection == null) {
                        return;
                    }
                    ProfilerView.this.start(ProfilerView.this.selection);
                }
            });
        }
    };
    private final Action action_stop = new Action("Stop", ImageCache.getImageDescriptor("icons/full/obj16/threads_obj.gif")){

        public void run() {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ProfilerView.this.selection == null) {
                        return;
                    }
                    ProfilerView.this.stop(ProfilerView.this.selection);
                }
            });
        }
    };
    private boolean disposed;
    private boolean launch_listener_ok;
    private TCFNode selection;
    private int sorting;
    private Update last_update;
    private Composite parent;
    private Label status;
    private TableViewer viewer;
    private ProfileEntry[] profile;
    private TCFNode profile_node;
    private static final String[] column_ids = new String[]{"Address", "Count", "Function", "File", "Line"};
    private static final int[] column_size = new int[]{80, 60, 250, 250, 60};

    public void createPartControl(Composite parent) {
        this.parent = parent;
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.status = new Label(composite, 0);
        this.status.setFont(font);
        this.status.setLayoutData((Object)new GridData(768));
        this.viewer = new TableViewer(composite, 66306);
        final Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.viewer.setContentProvider((IContentProvider)new ProfileContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider());
        this.viewer.setColumnProperties(column_ids);
        int i = 0;
        while (i < column_ids.length) {
            final int n = i;
            final TableColumn c = new TableColumn(table, 0, i);
            c.setText(column_ids[i]);
            c.setWidth(column_size[i]);
            if (i != 4) {
                c.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        table.setSortDirection(1024);
                        table.setSortColumn(c);
                        ProfilerView.this.sorting = n;
                        Protocol.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ProfilerView.this.updateView();
                            }
                        });
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            if (i == 1) {
                table.setSortDirection(1024);
                table.setSortColumn(c);
                this.sorting = n;
            }
            ++i;
        }
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ProfilerView.this.profile_node == null) {
                    return;
                }
                if (e.item == null) {
                    return;
                }
                ProfileEntry pe = (ProfileEntry)ProfilerView.this.viewer.getElementAt(table.indexOf((TableItem)e.item));
                if (pe.file_full == null) {
                    return;
                }
                ProfilerView.this.profile_node.getModel().displaySource(ProfilerView.this.profile_node.getID(), pe.file_full, pe.line);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.action_start.setEnabled(false);
        this.action_stop.setEnabled(false);
        IActionBars action_bars = this.getViewSite().getActionBars();
        IToolBarManager tool_bar = action_bars.getToolBarManager();
        tool_bar.add((IAction)this.action_start);
        tool_bar.add((IAction)this.action_stop);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", this.selection_listener);
        ISelection active_context = DebugUITools.getDebugContextManager().getContextService(window).getActiveContext();
        this.selection_listener.selectionChanged(null, active_context);
        Protocol.invokeLater((Runnable)this.read_data);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void start(TCFNode node) {
        assert (Protocol.isDispatchThread());
        if (!this.launch_listener_ok) {
            TCFModelManager.getModelManager().addListener(this.launch_listener);
            this.launch_listener_ok = true;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("FrameCnt", 4);
        this.configure(node, params);
    }

    public void stop(TCFNode node) {
        assert (Protocol.isDispatchThread());
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.configure(node, params);
    }

    private void configure(final TCFNode node, final Map<String, Object> params) {
        IProfiler profiler = (IProfiler)node.getChannel().getRemoteService(IProfiler.class);
        if (profiler != null) {
            profiler.configure(node.getID(), params, new IProfiler.DoneConfigure(){

                public void doneConfigure(IToken token, final Exception error) {
                    if (error == null) {
                        HashMap<String, ProfileData> m = (HashMap<String, ProfileData>)ProfilerView.this.data.get(node.getModel());
                        if (params.size() == 0) {
                            ProfileData d = null;
                            if (m != null) {
                                d = (ProfileData)m.get(node.getID());
                            }
                            if (d != null) {
                                d.stopped = true;
                            }
                        } else {
                            ProfileData d = new ProfileData(node.getID());
                            if (m == null) {
                                m = new HashMap<String, ProfileData>();
                                ProfilerView.this.data.put(node.getModel(), m);
                            }
                            m.put(d.ctx, d);
                        }
                        if (ProfilerView.this.selection == node) {
                            ProfilerView.this.updateView();
                        }
                    } else {
                        ProfilerView.this.parent.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox mb = new MessageBox(ProfilerView.this.parent.getShell(), 33);
                                mb.setText("Cannot start profiling");
                                mb.setMessage(TCFModel.getErrorMessage(error, true));
                                mb.open();
                            }
                        });
                    }
                }
            });
        }
        this.updateView();
    }

    private void addSamples(ProfileData p, Map<String, Object> props) {
        int size = 4;
        boolean big_endian = false;
        byte[] data = null;
        if (props != null) {
            Boolean b;
            Number n = (Number)props.get("AddrSize");
            if (n != null) {
                size = n.intValue();
            }
            if ((b = (Boolean)props.get("BigEndian")) != null) {
                big_endian = b;
            }
            data = (byte[])props.get("Data");
        }
        if (data == null) {
            return;
        }
        int pos = 0;
        byte[] buf = new byte[size + 1];
        BigInteger[] trace = new BigInteger[16];
        while (true) {
            int c = -1;
            int l = -1;
            int i = 0;
            while (pos + size <= data.length) {
                int j = 0;
                while (j < size) {
                    buf[big_endian ? j + 1 : size - j] = data[pos++];
                    ++j;
                }
                if (i >= trace.length) continue;
                BigInteger a = new BigInteger(buf);
                if (c < 0) {
                    c = a.intValue();
                    continue;
                }
                if (l < 0) {
                    l = a.intValue();
                    continue;
                }
                trace[i++] = a;
                if (i == l) break;
            }
            if (l < 0) break;
            if (i <= 0) continue;
            this.addSample(p, trace, i, c);
        }
    }

    private void addSample(ProfileData p, BigInteger[] trace, int len, int cnt) {
        p.sample_count += cnt;
        ArrayList<ProfileSample> lp = (ArrayList<ProfileSample>)p.get(trace[0]);
        if (lp != null) {
            for (ProfileSample s : lp) {
                int i = 0;
                while (i < len && trace[i].equals(s.trace[i])) {
                    ++i;
                }
                if (i != len) continue;
                s.cnt += cnt;
                return;
            }
        } else {
            lp = new ArrayList<ProfileSample>();
            p.put(trace[0], lp);
        }
        BigInteger[] t = new BigInteger[len];
        int i = 0;
        while (i < len) {
            t[i] = trace[i];
            ++i;
        }
        lp.add(new ProfileSample(cnt, t));
    }

    private void updateView() {
        assert (Protocol.isDispatchThread());
        this.last_update = new Update();
        Protocol.invokeLater((Runnable)this.last_update);
    }

    public void dispose() {
        this.disposed = true;
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                TCFModelManager.getModelManager().addListener(ProfilerView.this.launch_listener);
            }
        });
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", this.selection_listener);
        super.dispose();
    }

    static /* synthetic */ Update access$8(ProfilerView profilerView) {
        return profilerView.last_update;
    }

    private class ProfileContentProvider
    implements IStructuredContentProvider {
        private ProfileContentProvider() {
        }

        public Object[] getElements(Object input) {
            return ProfilerView.this.profile;
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }

        public void dispose() {
        }
    }

    private static class ProfileData
    extends HashMap<BigInteger, List<ProfileSample>> {
        final String ctx;
        boolean stopped;
        boolean unsupported;
        int sample_count;

        ProfileData(String ctx) {
            this.ctx = ctx;
        }
    }

    private static class ProfileEntry {
        BigInteger addr;
        String name;
        String file_full;
        String file_base;
        int line;
        int count;

        private ProfileEntry() {
        }
    }

    private class ProfileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProfileLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            ProfileEntry e = (ProfileEntry)element;
            switch (column) {
                case 0: {
                    return this.toHex(e.addr);
                }
                case 1: {
                    return Integer.toString(e.count);
                }
                case 2: {
                    return e.name;
                }
                case 3: {
                    return e.file_base;
                }
                case 4: {
                    return e.line == 0 ? null : Integer.toString(e.line);
                }
            }
            return null;
        }

        private String toHex(BigInteger n) {
            String s = n.toString(16);
            if (s.length() >= 8) {
                return s;
            }
            return String.valueOf("00000000".substring(s.length())) + s;
        }
    }

    private static class ProfileSample {
        int cnt;
        final BigInteger[] trace;

        ProfileSample(int cnt, BigInteger[] trace) {
            this.cnt = cnt;
            this.trace = trace;
        }
    }

    private class SampleComparator
    implements Comparator<ProfileEntry> {
        final int sorting;

        SampleComparator(int sorting) {
            this.sorting = sorting;
        }

        @Override
        public int compare(ProfileEntry x, ProfileEntry y) {
            int r = 0;
            switch (this.sorting) {
                case 0: {
                    r = x.addr.compareTo(y.addr);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (x.name == y.name) break;
                    if (x.name == null) {
                        return -1;
                    }
                    if (y.name == null) {
                        return 1;
                    }
                    r = x.name.compareTo(y.name);
                    break;
                }
                case 3: {
                    if (x.file_base == y.file_base) break;
                    if (x.file_base == null) {
                        return -1;
                    }
                    if (y.file_base == null) {
                        return 1;
                    }
                    r = x.file_base.compareTo(y.file_base);
                }
            }
            if (r != 0) {
                return r;
            }
            if (x.count > y.count) {
                return -1;
            }
            if (x.count < y.count) {
                return 1;
            }
            return 0;
        }
    }

    private class Update
    implements Runnable {
        final TCFNode selection;
        final int sorting;
        final List<ProfileEntry> lst = new ArrayList<ProfileEntry>();
        final Map<BigInteger, String> funcs = new HashMap<BigInteger, String>();
        final TCFNodeExecContext node;
        final ProfileData prof_data;
        final List<ProfileSample>[] samples;
        final ISymbols symbols;
        final ILineNumbers line_numbers;
        boolean done;
        int pos;

        Update() {
            Map m;
            assert (Protocol.isDispatchThread());
            this.selection = ProfilerView.this.selection;
            this.sorting = ProfilerView.this.sorting;
            ProfileData p = null;
            if (this.selection != null && (m = (Map)ProfilerView.this.data.get(this.selection.getModel())) != null) {
                p = (ProfileData)m.get(this.selection.getID());
            }
            this.prof_data = p;
            if (p == null) {
                this.node = null;
                this.samples = null;
                this.symbols = null;
                this.line_numbers = null;
            } else {
                this.node = (TCFNodeExecContext)this.selection;
                this.symbols = (ISymbols)this.node.getChannel().getRemoteService(ISymbols.class);
                this.line_numbers = (ILineNumbers)this.node.getChannel().getRemoteService(ILineNumbers.class);
                this.samples = p.values().toArray(new List[p.values().size()]);
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block19: {
                if (this.done) {
                    return;
                }
                if (ProfilerView.access$8(ProfilerView.this) != this) {
                    return;
                }
                if (this.samples == null || this.pos >= this.samples.length) break block19;
                if (!this.node.isDisposed()) ** GOTO lbl64
                this.lst.clear();
                break block19;
lbl-1000:
                // 1 sources

                {
                    s = this.samples[this.pos];
                    count = 0;
                    addr = null;
                    for (ProfileSample x : s) {
                        if (addr == null) {
                            addr = x.trace[0];
                        }
                        count += x.cnt;
                    }
                    if (addr != null) {
                        func_name = null;
                        file_full = null;
                        file_base = null;
                        line = 0;
                        if (this.symbols != null) {
                            func_id = this.funcs.get(addr);
                            if (func_id == null) {
                                func_id = "";
                                func_cache = this.node.getFuncInfo(addr);
                                if (func_cache != null) {
                                    if (!func_cache.validate((Runnable)this)) {
                                        return;
                                    }
                                    func_data = (TCFFunctionRef)func_cache.getData();
                                    if (func_data != null && func_data.symbol_id != null) {
                                        func_id = func_data.symbol_id;
                                    }
                                }
                                this.funcs.put(addr, func_id);
                            }
                            if (func_id.length() > 0) {
                                sym_cache = this.node.getModel().getSymbolInfoCache(func_id);
                                if (!sym_cache.validate((Runnable)this)) {
                                    return;
                                }
                                sym_data = (ISymbols.Symbol)sym_cache.getData();
                                if (sym_data != null && sym_data.getName() != null) {
                                    func_name = sym_data.getName();
                                }
                            }
                        }
                        if (this.line_numbers != null && (line_cache = this.node.getLineInfo(addr)) != null) {
                            if (!line_cache.validate((Runnable)this)) {
                                return;
                            }
                            line_data = (TCFSourceRef)line_cache.getData();
                            if (line_data != null && line_data.area != null && (file_full = TCFSourceLookupParticipant.toFileName((ILineNumbers.CodeArea)line_data.area)) != null) {
                                file_base = file_full;
                                i = file_base.lastIndexOf(47);
                                if (i > (j = file_base.lastIndexOf(92))) {
                                    file_base = file_base.substring(i + 1);
                                }
                                if (i < j) {
                                    file_base = file_base.substring(j + 1);
                                }
                                line = line_data.area.start_line;
                            }
                        }
                        e = new ProfileEntry();
                        e.addr = addr;
                        e.count = count;
                        e.name = func_name;
                        e.file_full = file_full;
                        e.file_base = file_base;
                        e.line = line;
                        this.lst.add(e);
                    }
                    ++this.pos;
lbl64:
                    // 2 sources

                    ** while (this.pos < this.samples.length)
                }
            }
            this.done = true;
            entries = this.lst.toArray(new ProfileEntry[this.lst.size()]);
            Arrays.sort(entries, new SampleComparator(this.sorting));
            enable_start = this.selection instanceof TCFNodeExecContext != false && this.selection.getChannel().getRemoteService(IProfiler.class) != null;
            enable_stop = this.node != null && this.prof_data.stopped == false;
            stopped = this.node != null && this.prof_data.stopped != false;
            running = this.node != null && stopped == false;
            unsupported = this.node != null && this.prof_data.unsupported != false;
            sample_count = this.prof_data == null ? 0 : this.prof_data.sample_count;
            ProfilerView.access$9(ProfilerView.this).getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProfilerView.this.action_start.setEnabled(enable_start);
                    ProfilerView.this.action_stop.setEnabled(enable_stop);
                    ProfilerView.this.profile_node = Update.this.node;
                    ProfilerView.this.profile = entries;
                    ProfilerView.this.viewer.setInput((Object)entries);
                    if (!enable_start) {
                        ProfilerView.this.status.setText("Selected context does not support profiling");
                    } else if (unsupported) {
                        ProfilerView.this.status.setText("No suitable profiler found for selected context");
                    } else if (stopped) {
                        ProfilerView.this.status.setText("Profiler stopped. Press 'Start' button to restart profiling");
                    } else if (running) {
                        ProfilerView.this.status.setText("Profiler runnning. " + sample_count + " samples");
                    } else {
                        ProfilerView.this.status.setText("Idle. Press 'Start' button to start profiling");
                    }
                }
            });
        }
    }
}

