/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.PathMapRuleDialog;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.ui.PlatformUI;

public class TCFPathMapTab
extends AbstractLaunchConfigurationTab {
    private TableViewer viewer;
    private Button button_add;
    private Button button_edit;
    private Button button_remove;
    private MenuItem item_add;
    private MenuItem item_edit;
    private MenuItem item_remove;
    private static final String[] column_ids = new String[]{"Source", "Destination", "ContextQuery"};
    private static final int[] column_size = new int[]{300, 300, 100};
    private static final String TAB_ID = "org.eclipse.tcf.launch.pathMapTab";
    private ArrayList<TCFLaunchDelegate.PathMapRule> map;
    private Exception init_error;

    public String getName() {
        return "Path Map";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/path.gif");
    }

    public String getId() {
        return TAB_ID;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createTable(composite);
        this.setControl((Control)composite);
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Label map_label = new Label(parent, 64);
        map_label.setLayoutData((Object)new GridData(768));
        map_label.setFont(font);
        map_label.setText("File Path Map Rules:");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer = new TableViewer(composite, 68354);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.viewer.setContentProvider((IContentProvider)new FileMapContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileMapLabelProvider());
        this.viewer.setColumnProperties(column_ids);
        int i = 0;
        while (i < column_ids.length) {
            TableColumn c = new TableColumn(table, 0, i);
            c.setText(this.getColumnText(i));
            c.setWidth(this.getColumnWidth(i));
            ++i;
        }
        this.createTableButtons(composite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TCFPathMapTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TCFPathMapTab.this.button_edit.isEnabled()) {
                    TCFPathMapTab.this.onEdit((IStructuredSelection)TCFPathMapTab.this.viewer.getSelection());
                }
            }
        });
    }

    protected String getColumnText(int column) {
        return column_ids[column];
    }

    protected int getColumnWidth(int column) {
        return column_size[column];
    }

    private void createTableButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(272);
        composite.setLayoutData((Object)gd);
        Menu menu = new Menu((Control)this.viewer.getTable());
        SelectionAdapter sel_adapter = null;
        this.button_add = new Button(composite, 8);
        this.button_add.setText(" &Add... ");
        gd = new GridData(256);
        this.button_add.setLayoutData((Object)gd);
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFLaunchDelegate.PathMapRule pathMapRule = new TCFLaunchDelegate.PathMapRule(new LinkedHashMap());
                PathMapRuleDialog dialog = new PathMapRuleDialog(TCFPathMapTab.this.getShell(), null, (IPathMap.PathMapRule)pathMapRule, true);
                if (dialog.open() == 0) {
                    TCFPathMapTab.this.map.add(pathMapRule);
                    TCFPathMapTab.this.viewer.add((Object)pathMapRule);
                    TCFPathMapTab.this.viewer.setSelection((ISelection)new StructuredSelection((Object)pathMapRule), true);
                    TCFPathMapTab.this.viewer.getTable().setFocus();
                    TCFPathMapTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
        this.button_add.addSelectionListener((SelectionListener)sel_adapter);
        this.item_add = new MenuItem(menu, 8);
        this.item_add.setText("&Add...");
        this.item_add.addSelectionListener((SelectionListener)sel_adapter);
        this.item_add.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.button_edit = new Button(composite, 8);
        this.button_edit.setText(" &Edit... ");
        this.button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFPathMapTab.this.onEdit((IStructuredSelection)TCFPathMapTab.this.viewer.getSelection());
            }
        };
        this.button_edit.addSelectionListener((SelectionListener)sel_adapter);
        this.item_edit = new MenuItem(menu, 8);
        this.item_edit.setText("&Edit...");
        this.item_edit.addSelectionListener((SelectionListener)sel_adapter);
        this.button_remove = new Button(composite, 8);
        this.button_remove.setText(" &Remove ");
        this.button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TCFLaunchDelegate.PathMapRule pathMapRule : (IStructuredSelection)TCFPathMapTab.this.viewer.getSelection()) {
                    TCFPathMapTab.this.map.remove(pathMapRule);
                    TCFPathMapTab.this.viewer.remove((Object)pathMapRule);
                }
                TCFPathMapTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.button_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.item_remove = new MenuItem(menu, 8);
        this.item_remove.setText("&Remove");
        this.item_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.item_remove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        this.viewer.getTable().setMenu(menu);
    }

    private void onEdit(IStructuredSelection selection) {
        TCFLaunchDelegate.PathMapRule pathMapRule = (TCFLaunchDelegate.PathMapRule)selection.getFirstElement();
        PathMapRuleDialog dialog = new PathMapRuleDialog(this.getShell(), null, (IPathMap.PathMapRule)pathMapRule, true);
        dialog.open();
        this.viewer.refresh((Object)pathMapRule);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)pathMapRule), true);
        this.viewer.getTable().setFocus();
        this.updateLaunchConfigurationDialog();
    }

    protected final TableViewer getViewer() {
        return this.viewer;
    }

    List<IPathMap.PathMapRule> getPathMap() {
        ArrayList<TCFLaunchDelegate.PathMapRule> l = new ArrayList<TCFLaunchDelegate.PathMapRule>();
        for (TCFLaunchDelegate.PathMapRule r : this.map) {
            l.add(r);
        }
        return Collections.unmodifiableList(l);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            String s = config.getAttribute("org.eclipse.tcf.debug.PathMap", "");
            this.map = TCFLaunchDelegate.parsePathMapAttribute((String)s);
            this.viewer.setInput((Object)config);
            this.button_remove.setEnabled(!this.viewer.getSelection().isEmpty());
            this.button_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
            this.item_remove.setEnabled(!this.viewer.getSelection().isEmpty());
            this.item_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
        }
        catch (Exception e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + e);
            Activator.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        for (TCFLaunchDelegate.PathMapRule m : this.map) {
            m.getProperties().remove("ID");
        }
        StringBuffer bf = new StringBuffer();
        for (TCFLaunchDelegate.PathMapRule m : this.map) {
            bf.append(m.toString());
        }
        if (bf.length() == 0) {
            config.removeAttribute("org.eclipse.tcf.debug.PathMap");
        } else {
            config.setAttribute("org.eclipse.tcf.debug.PathMap", bf.toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.removeAttribute("org.eclipse.tcf.debug.PathMap");
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.button_remove.setEnabled(!this.viewer.getSelection().isEmpty());
        this.button_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
        this.item_remove.setEnabled(!this.viewer.getSelection().isEmpty());
        this.item_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class FileMapContentProvider
    implements IStructuredContentProvider {
        private FileMapContentProvider() {
        }

        public Object[] getElements(Object input) {
            return TCFPathMapTab.this.map.toArray(new TCFLaunchDelegate.PathMapRule[TCFPathMapTab.this.map.size()]);
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }

        public void dispose() {
        }
    }

    private class FileMapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FileMapLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            if (column == 0) {
                return ImageCache.getImage("icons/attribute.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int column) {
            TCFLaunchDelegate.PathMapRule e = (TCFLaunchDelegate.PathMapRule)element;
            Object o = e.getProperties().get(column_ids[column]);
            if (o == null) {
                return "";
            }
            return o.toString();
        }
    }
}

