/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.model;

import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.cxx.model.ICIndexChecker;
import org.eclipse.cdt.codan.core.model.AbstractCheckerWithProblemPreferences;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCIndexChecker
extends AbstractCheckerWithProblemPreferences
implements ICIndexChecker {
    private IFile file;
    protected IIndex index;

    protected IFile getFile() {
        return this.file;
    }

    void processFile(IFile file) throws CoreException, InterruptedException {
        ICElement model = CoreModel.getDefault().create(file);
        if (!(model instanceof ITranslationUnit)) {
            return;
        }
        ITranslationUnit tu = (ITranslationUnit)model;
        this.index = CCorePlugin.getIndexManager().getIndex(tu.getCProject());
        this.index.acquireReadLock();
        try {
            this.file = file;
            this.processUnit(tu);
        }
        finally {
            this.file = null;
            this.index.releaseReadLock();
        }
    }

    public synchronized boolean processResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                this.processFile(file);
            }
            catch (CoreException e) {
                CodanCorePlugin.log((Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
        return true;
    }

    public boolean runInEditor() {
        return false;
    }
}

